/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.annotation;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.uima.caseditor.editor.util.Span;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

final class BackgroundDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    BackgroundDrawingStrategy() {
    }

    public void draw(Annotation annotation, GC gc, StyledText textWidget, int annotationBegin, int length, Color color) {
        if (length != 0) {
            if (gc != null) {
                int annotationEnd = annotationBegin + length;
                Rectangle bounds = textWidget.getTextBounds(annotationBegin, annotationEnd - 1);
                ArrayList<Span> dontOverDrawSpans = new ArrayList<Span>();
                Span annotationSpan = new Span(annotationBegin, length);
                for (StyleRange styleRange : textWidget.getStyleRanges(annotationBegin, length)) {
                    Span styleRangeSpan = new Span(styleRange.start, styleRange.length);
                    if (styleRangeSpan.getLength() <= 0) continue;
                    dontOverDrawSpans.add(styleRangeSpan);
                }
                Point selection = textWidget.getSelection();
                Span selectionSpan = new Span(selection.x, selection.y - selection.x);
                if (annotationSpan.isIntersecting(selectionSpan) && selectionSpan.getLength() > 0) {
                    dontOverDrawSpans.add(selectionSpan);
                }
                Collections.sort(dontOverDrawSpans);
                Collections.reverse(dontOverDrawSpans);
                gc.setBackground(color);
                if (dontOverDrawSpans.size() > 0) {
                    int zBegin = annotationBegin;
                    for (Span xSpan : dontOverDrawSpans) {
                        if (xSpan.getLength() > 0 && zBegin < xSpan.getStart()) {
                            Rectangle selectionBounds = textWidget.getTextBounds(zBegin, xSpan.getStart() - 1);
                            gc.fillRectangle(selectionBounds);
                        }
                        if (zBegin >= xSpan.getEnd()) continue;
                        zBegin = xSpan.getEnd();
                    }
                    if (zBegin < annotationEnd) {
                        Rectangle selectionBounds = textWidget.getTextBounds(zBegin, annotationEnd - 1);
                        gc.fillRectangle(selectionBounds);
                    }
                } else {
                    Rectangle selectionBounds = textWidget.getTextBounds(annotationBegin, annotationEnd - 1);
                    gc.fillRectangle(selectionBounds);
                }
                int end = annotationBegin + length - 1;
                gc.setForeground(new Color(gc.getDevice(), 0, 0, 0));
                String annotationText = textWidget.getText(annotationBegin, end);
                if (annotationText.contains("\t")) {
                    char[] replacementSpaces = new char[textWidget.getTabs()];
                    for (int i = 0; i < replacementSpaces.length; ++i) {
                        replacementSpaces[i] = 32;
                    }
                    annotationText = annotationText.replace(new String(new char[]{'\t'}), new String(replacementSpaces));
                }
                gc.drawText(annotationText, bounds.x, bounds.y, true);
            } else {
                textWidget.redrawRange(annotationBegin, length, true);
            }
        }
    }
}

