/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.ui;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.dvb.ui.FontFormatException;
import org.dvb.ui.FontNotAvailableException;
import org.videolan.BDJLoader;
import org.videolan.BDJUtil;
import org.videolan.FontIndex;
import org.videolan.FontIndexData;
import org.videolan.Logger;

public class FontFactory {
    private Font urlFont = null;
    private static Map fonts = null;
    private static Map fontIds = null;
    private static final Logger logger = Logger.getLogger(FontFactory.class.getName());

    public static synchronized void loadDiscFonts() {
        FontFactory.unloadDiscFonts();
    }

    public static synchronized void unloadDiscFonts() {
        fonts = null;
        fontIds = null;
    }

    private static synchronized void readDiscFonts() throws FontFormatException, IOException {
        if (fonts != null) {
            return;
        }
        String path = BDJUtil.discRootToFilesystem("/BDMV/AUXDATA/dvb.fontindex");
        FontIndexData[] fontIndexData = FontIndex.parseIndex(path);
        fonts = new HashMap(fontIndexData.length);
        fontIds = new HashMap(fontIndexData.length);
        for (int i = 0; i < fontIndexData.length; ++i) {
            FontIndexData data = fontIndexData[i];
            try {
                File fontFile = BDJLoader.addFont(data.getFileName());
                if (fontFile == null) {
                    throw new IOException("error caching font");
                }
                if (data.getStyle() == -1) {
                    logger.unimplemented("readDiscFonts(): font with all styles not supported");
                }
                Font font = Font.createFont(0, fontFile);
                font = font.deriveFont(data.getStyle(), 1);
                fonts.put(data.getName() + "." + font.getStyle(), font);
                fontIds.put(data.getFileName().substring(0, 5), font);
                continue;
            }
            catch (IOException ex) {
                logger.error("Failed reading font " + data.getName() + " from " + data.getFileName() + ": " + ex);
                if (i != fontIndexData.length - 1 || fonts.size() >= 1) continue;
                logger.error("didn't load any fonts !");
                throw ex;
            }
            catch (java.awt.FontFormatException ex) {
                logger.error("Failed reading font " + data.getName() + " from " + data.getFileName() + ": " + ex);
                if (i != fontIndexData.length - 1 || fonts.size() >= 1) continue;
                logger.error("didn't load any fonts !");
                throw new FontFormatException();
            }
        }
    }

    public FontFactory() throws FontFormatException, IOException {
        FontFactory.readDiscFonts();
    }

    public FontFactory(URL u) throws IOException, FontFormatException {
        InputStream inStream = null;
        try {
            inStream = u.openStream();
            File fontFile = BDJLoader.addFont(inStream);
            if (fontFile == null) {
                throw new IOException("error caching font");
            }
            this.urlFont = Font.createFont(0, fontFile);
            this.urlFont = this.urlFont.deriveFont(this.urlFont.getStyle(), 1);
        }
        catch (IOException ex) {
            logger.error("Failed reading font from " + u.getPath() + ": " + ex);
            throw ex;
        }
        catch (java.awt.FontFormatException ex) {
            logger.error("Failed reading font from " + u.getPath() + ": " + ex);
            throw new FontFormatException();
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font createFont(String fontId) {
        Font font = null;
        Class clazz = FontFactory.class;
        synchronized (clazz) {
            font = (Font)fontIds.get(fontId);
        }
        if (font != null) {
            return font.deriveFont(0, 12);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font createFont(String name, int style, int size) throws FontNotAvailableException, FontFormatException, IOException {
        logger.info("Creating font: " + name + " " + style + " " + size);
        if (style < 0 || size <= 0 || (style & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException();
        }
        if (this.urlFont != null) {
            if (name.equals(this.urlFont.getName()) && style == this.urlFont.getStyle()) {
                return this.urlFont.deriveFont(style, size);
            }
            logger.info("createFont(URL): request " + name + "." + style + " does not match with " + this.urlFont.getName() + "." + this.urlFont.getStyle());
            throw new FontNotAvailableException();
        }
        Font font = null;
        Class clazz = FontFactory.class;
        synchronized (clazz) {
            font = (Font)fonts.get(name + "." + style);
        }
        if (font == null) {
            logger.info("Font " + name + "." + style + " not found");
            throw new FontNotAvailableException();
        }
        return font.deriveFont(style, size);
    }
}

