/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.awt.AWTPermission;
import java.io.BDFileSystem;
import java.io.File;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.PropertyPermission;
import javax.tv.media.MediaSelectPermission;
import javax.tv.service.ReadPermission;
import javax.tv.service.selection.SelectPermission;
import javax.tv.service.selection.ServiceContextPermission;
import org.bluray.vfs.VFSPermission;
import org.dvb.application.AppsControlPermission;
import org.dvb.media.DripFeedPermission;
import org.dvb.user.UserPreferencePermission;
import org.videolan.BDJLoader;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

final class BDJSecurityManager
extends SecurityManager {
    private String discRoot;
    private String cacheRoot;
    private String budaRoot;
    private String persistentRoot;
    private boolean usingUdf = false;
    private static Class urlPermission = null;
    private static final Logger logger;

    BDJSecurityManager(String discRoot, String persistentRoot, String budaRoot) {
        this.discRoot = discRoot;
        this.cacheRoot = null;
        this.budaRoot = budaRoot;
        this.persistentRoot = persistentRoot;
        if (discRoot == null) {
            this.usingUdf = true;
        }
    }

    protected void setCacheRoot(String root) {
        if (this.cacheRoot != null && !root.startsWith(this.cacheRoot)) {
            logger.error("setCacheRoot(" + root + ") denied\n" + Logger.dumpStack());
            throw new SecurityException("cache root already set");
        }
        this.cacheRoot = root;
    }

    private void deny(Permission perm) {
        logger.error("denied " + perm + "\n" + Logger.dumpStack());
        throw new SecurityException("denied " + perm);
    }

    public void checkPermission(Permission perm) {
        if (perm instanceof RuntimePermission) {
            if (perm.implies(new RuntimePermission("createSecurityManager"))) {
                if (this.classDepth("javax.crypto.JceSecurityManager") < 3) {
                    return;
                }
                this.deny(perm);
            }
            if (perm.implies(new RuntimePermission("setSecurityManager"))) {
                if (this.classDepth("org.videolan.Libbluray") == 3) {
                    return;
                }
                this.deny(perm);
            }
            if (this.classDepth("sun.awt.AWTAutoShutdown") > 0) {
                return;
            }
            if (perm.implies(new RuntimePermission("modifyThreadGroup"))) {
                super.checkPermission(perm);
            }
        } else if (perm instanceof PropertyPermission) {
            if (perm.getActions().equals("read")) {
                String prop = perm.getName();
                if (prop.startsWith("bluray.") || prop.startsWith("dvb.") || prop.startsWith("mhp.") || prop.startsWith("aacs.")) {
                    return;
                }
                if (prop.startsWith("user.dir")) {
                    return;
                }
            }
            try {
                super.checkPermission(perm);
            }
            catch (Exception e) {
                logger.info(perm + " denied by system");
                throw new SecurityException("denied " + perm);
            }
        } else if (perm instanceof FilePermission) {
            String file;
            if (perm.getActions().equals("delete")) {
                this.checkWrite(perm.getName());
                return;
            }
            if (perm.getActions().equals("read") && this.canRead(file = this.getCanonPath(perm.getName()))) {
                if (this.usingUdf) {
                    BDJLoader.accessFile(file);
                }
                return;
            }
            if (perm.getActions().contains("write")) {
                this.deny(perm);
            }
        } else if (perm instanceof SocketPermission) {
            if (new SocketPermission("*", "connect,resolve").implies(perm)) {
                return;
            }
        } else {
            if (urlPermission != null && urlPermission.isInstance(perm)) {
                logger.info("grant " + perm);
                return;
            }
            if (perm instanceof ReadPermission) {
                return;
            }
            if (perm instanceof ServiceContextPermission) {
                return;
            }
            if (perm instanceof SelectPermission) {
                return;
            }
            if (perm instanceof MediaSelectPermission) {
                return;
            }
            if (perm instanceof AppsControlPermission) {
                return;
            }
            if (perm instanceof DripFeedPermission) {
                return;
            }
            if (perm instanceof UserPreferencePermission) {
                return;
            }
            if (perm instanceof VFSPermission) {
                return;
            }
            if (perm instanceof AWTPermission && perm.getName().equals("accessClipboard")) {
                AccessController.checkPermission(perm);
                return;
            }
        }
        try {
            AccessController.checkPermission(perm);
        }
        catch (AccessControlException ex) {
            System.err.println(" *** caught " + ex + " at\n" + Logger.dumpStack());
            throw ex;
        }
    }

    public void checkExec(String cmd) {
        logger.error("Exec(" + cmd + ") denied\n" + Logger.dumpStack());
        throw new SecurityException("exec denied");
    }

    public void checkExit(int status) {
        logger.error("Exit(" + status + ") denied\n" + Logger.dumpStack());
        throw new SecurityException("exit denied");
    }

    public void checkSystemClipboardAccess() {
        throw new SecurityException("clipboard access denied");
    }

    private boolean canRead(String file) {
        if (this.cacheRoot != null && file.startsWith(this.cacheRoot)) {
            return true;
        }
        if (this.discRoot != null && file.startsWith(this.discRoot)) {
            return true;
        }
        if (this.budaRoot != null && file.startsWith(this.budaRoot)) {
            return true;
        }
        return this.persistentRoot != null && file.startsWith(this.persistentRoot);
    }

    private boolean canWrite(String file) {
        if (this.budaRoot != null && file.startsWith(this.budaRoot)) {
            return true;
        }
        if (this.persistentRoot != null && file.startsWith(this.persistentRoot)) {
            return true;
        }
        BDJXletContext ctx = BDJXletContext.getCurrentContext();
        if (ctx != null) {
            logger.error("Xlet write " + file + " denied at\n" + Logger.dumpStack());
            return false;
        }
        if (this.cacheRoot != null && file.startsWith(this.cacheRoot)) {
            return true;
        }
        logger.error("BD-J write " + file + " denied at\n" + Logger.dumpStack());
        return false;
    }

    public void checkWrite(String file) {
        if (this.canWrite(file = this.getCanonPath(file))) {
            return;
        }
        throw new SecurityException("write access denied");
    }

    private String getCanonPath(String origPath) {
        String path;
        String cpath;
        String suffix = "";
        if (!BDFileSystem.isAbsolutePath(origPath)) {
            String home = BDJXletContext.getCurrentXletHome();
            if (home == null) {
                logger.error("Relative path " + origPath + " outside Xlet context\n" + Logger.dumpStack());
                return origPath;
            }
            origPath = home + origPath;
        }
        if (origPath.endsWith(File.separator + "*")) {
            suffix = File.separator + "*";
            origPath = origPath.substring(0, origPath.length() - 2);
        }
        if ((cpath = (String)AccessController.doPrivileged(new PrivilegedAction(path = origPath){
            private final /* synthetic */ String val$path;
            {
                this.val$path = string;
            }

            public Object run() {
                try {
                    return new File(this.val$path).getCanonicalPath();
                }
                catch (Exception ioe) {
                    logger.error("error canonicalizing " + this.val$path + ": " + ioe);
                    return null;
                }
            }
        })) == null) {
            throw new SecurityException("cant canonicalize " + path);
        }
        return cpath + suffix;
    }

    static {
        try {
            urlPermission = Class.forName("java.net.URLPermission");
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger = Logger.getLogger(BDJSecurityManager.class.getName());
    }
}

