/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ti;

import java.util.Date;
import javax.tv.locator.Locator;
import javax.tv.service.Service;
import javax.tv.service.ServiceInformationType;
import javax.tv.service.navigation.StreamType;
import org.bluray.net.BDLocator;
import org.bluray.ti.CodingType;
import org.bluray.ti.Title;
import org.bluray.ti.TitleComponent;
import org.bluray.ti.TitleImpl;
import org.bluray.ti.TitleInformationType;
import org.davic.net.InvalidLocatorException;
import org.videolan.Logger;
import org.videolan.StreamInfo;

public class TitleComponentImpl
implements TitleComponent {
    int stn;
    StreamInfo stream;
    StreamType type;
    boolean primary;
    int playlistId;
    int playitemId;
    Title service;

    protected TitleComponentImpl(int stn, StreamInfo stream, StreamType type, boolean primary, int playlistId, int playitemId, Title service) {
        this.stn = stn;
        this.stream = stream;
        this.type = type;
        this.primary = primary;
        this.playlistId = playlistId;
        this.playitemId = playitemId;
        this.service = service;
    }

    public String getName() {
        BDLocator l = (BDLocator)this.getLocator();
        if (l == null) {
            return null;
        }
        return l.toString();
    }

    public String getAssociatedLanguage() {
        return this.stream.getLang();
    }

    public StreamType getStreamType() {
        return this.type;
    }

    public Service getService() {
        return this.service;
    }

    public Locator getLocator() {
        String str = "bd://" + ((TitleImpl)this.service).getTitleNum() + ".PLAYLIST:" + this.playlistId + ".ITEM:" + this.playitemId;
        if (this.type.equals(StreamType.AUDIO) && this.primary) {
            str = str + ".A1:" + this.stn;
        } else if (this.type.equals(StreamType.VIDEO) && this.primary) {
            str = str + ".V1:" + this.stn;
        } else if (this.type.equals(StreamType.AUDIO) && !this.primary) {
            str = str + ".A2:" + this.stn;
        } else if (this.type.equals(StreamType.VIDEO) && !this.primary) {
            str = str + ".V2:" + this.stn;
        } else if (this.type.equals(StreamType.SUBTITLES) && this.primary) {
            str = str + ".P:" + this.stn;
        } else {
            return null;
        }
        try {
            return new BDLocator(str);
        }
        catch (InvalidLocatorException e) {
            return null;
        }
    }

    public ServiceInformationType getServiceInformationType() {
        return TitleInformationType.BD_ROM;
    }

    public Date getUpdateTime() {
        Logger.unimplemented(TitleComponentImpl.class.getName(), "getUpdateTime");
        return null;
    }

    public CodingType getCodingType() {
        return this.stream.getCodingType();
    }

    public int getStreamNumber() {
        return this.stn;
    }

    public int getSubPathId() {
        return this.stream.getSubPathId();
    }
}

