/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.zzu;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractPendingResult<R extends Result>
implements PendingResult<R> {
    private final Object zzWb = new Object();
    protected final CallbackHandler<R> mHandler;
    private final CountDownLatch zzoD = new CountDownLatch(1);
    private final ArrayList<PendingResult.BatchCallback> zzWc = new ArrayList();
    private ResultCallback<R> zzWd;
    private volatile R zzWe;
    private volatile boolean zzWf;
    private boolean zzL;
    private boolean zzWg;
    private ICancelToken zzWh;

    protected AbstractPendingResult(Looper looper) {
        this.mHandler = new CallbackHandler(looper);
    }

    protected AbstractPendingResult(CallbackHandler<R> callbackHandler) {
        this.mHandler = zzu.zzb(callbackHandler, (Object)"CallbackHandler must not be null");
    }

    public final boolean isReady() {
        return this.zzoD.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzu.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
        zzu.zza(!this.zzWf, (Object)"Result has already been consumed");
        try {
            this.zzoD.await();
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.zzXQ);
        }
        zzu.zza(this.isReady(), (Object)"Result is not ready.");
        return this.zzmo();
    }

    @Override
    public final R await(long time, TimeUnit units) {
        zzu.zza(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzu.zza(!this.zzWf, (Object)"Result has already been consumed.");
        try {
            boolean bl = this.zzoD.await(time, units);
            if (!bl) {
                this.forceFailureUnlessReady(Status.zzXS);
            }
        }
        catch (InterruptedException interruptedException) {
            this.forceFailureUnlessReady(Status.zzXQ);
        }
        zzu.zza(this.isReady(), (Object)"Result is not ready.");
        return this.zzmo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback) {
        zzu.zza(!this.zzWf, (Object)"Result has already been consumed.");
        Object object = this.zzWb;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.mHandler.sendResultCallback(callback, this.zzmo());
            } else {
                this.zzWd = callback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
        zzu.zza(!this.zzWf, (Object)"Result has already been consumed.");
        Object object = this.zzWb;
        synchronized (object) {
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.mHandler.sendResultCallback(callback, this.zzmo());
            } else {
                this.zzWd = callback;
                this.mHandler.sendTimeoutResultCallback(this, units.toMillis(time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addBatchCallback(PendingResult.BatchCallback callback) {
        zzu.zza(!this.zzWf, (Object)"Result has already been consumed.");
        Object object = this.zzWb;
        synchronized (object) {
            if (this.isReady()) {
                callback.zzs(this.zzWe.getStatus());
            } else {
                this.zzWc.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzWb;
        synchronized (object) {
            if (this.zzL || this.zzWf) {
                return;
            }
            if (this.zzWh != null) {
                try {
                    this.zzWh.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            AbstractPendingResult.zzb(this.zzWe);
            this.zzWd = null;
            this.zzL = true;
            this.zza(this.createFailedResult(Status.zzXT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzWb;
        synchronized (object) {
            return this.zzL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R result) {
        Object object = this.zzWb;
        synchronized (object) {
            if (this.zzWg || this.zzL) {
                AbstractPendingResult.zzb(result);
                return;
            }
            zzu.zza(!this.isReady(), (Object)"Results have already been set");
            zzu.zza(!this.zzWf, (Object)"Result has already been consumed");
            this.zza(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forceFailureUnlessReady(Status status) {
        Object object = this.zzWb;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.createFailedResult(status));
                this.zzWg = true;
            }
        }
    }

    protected abstract R createFailedResult(Status var1);

    protected void onResultConsumed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setCancelToken(ICancelToken cancelToken) {
        Object object = this.zzWb;
        synchronized (object) {
            this.zzWh = cancelToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R zzmo() {
        R r;
        Object object = this.zzWb;
        synchronized (object) {
            zzu.zza(!this.zzWf, (Object)"Result has already been consumed.");
            zzu.zza(this.isReady(), (Object)"Result is not ready.");
            r = this.zzWe;
            this.zzWe = null;
            this.zzWd = null;
            this.zzWf = true;
        }
        this.onResultConsumed();
        return r;
    }

    private void zza(R r) {
        this.zzWe = r;
        this.zzWh = null;
        this.zzoD.countDown();
        Status status = this.zzWe.getStatus();
        if (this.zzWd != null) {
            this.mHandler.removeTimeoutMessages();
            if (!this.zzL) {
                this.mHandler.sendResultCallback(this.zzWd, this.zzmo());
            }
        }
        for (PendingResult.BatchCallback batchCallback : this.zzWc) {
            batchCallback.zzs(status);
        }
        this.zzWc.clear();
    }

    static void zzb(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"AbstractPendingResult", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class CallbackHandler<R extends Result>
    extends Handler {
        public static final int CALLBACK_ON_COMPLETE = 1;
        public static final int CALLBACK_ON_TIMEOUT = 2;

        public CallbackHandler() {
            this(Looper.getMainLooper());
        }

        public CallbackHandler(Looper looper) {
            super(looper);
        }

        public void sendResultCallback(ResultCallback<R> callback, R result) {
            this.sendMessage(this.obtainMessage(1, new Pair(callback, result)));
        }

        public void sendTimeoutResultCallback(AbstractPendingResult<R> pendingResult, long millis) {
            this.sendMessageDelayed(this.obtainMessage(2, pendingResult), millis);
        }

        public void removeTimeoutMessages() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.deliverResultCallback((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    AbstractPendingResult abstractPendingResult = (AbstractPendingResult)msg.obj;
                    abstractPendingResult.forceFailureUnlessReady(Status.zzXS);
                    return;
                }
            }
            Log.wtf((String)"AbstractPendingResult", (String)"Don't know how to handle this message.");
        }

        protected void deliverResultCallback(ResultCallback<R> callback, R result) {
            try {
                callback.onResult(result);
            }
            catch (RuntimeException runtimeException) {
                AbstractPendingResult.zzb(result);
                throw runtimeException;
            }
        }
    }
}

