/*
 * Decompiled with CFR 0.152.
 */
package com.xensource.xenapi;

import com.xensource.xenapi.Connection;
import com.xensource.xenapi.Host;
import com.xensource.xenapi.Marshalling;
import com.xensource.xenapi.Types;
import com.xensource.xenapi.XenAPIObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlrpc.XmlRpcException;

public class Task
extends XenAPIObject {
    protected final String ref;

    Task(String string) {
        this.ref = string;
    }

    @Override
    public String toWireString() {
        return this.ref;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Task) {
            Task task = (Task)object;
            return task.ref.equals(this.ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public Record getRecord(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_record";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTaskRecord(v);
    }

    public static Task getByUuid(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "task.get_by_uuid";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public static Set<Task> getByNameLabel(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "task.get_by_name_label";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfTask(v);
    }

    public String getUuid(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_uuid";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameLabel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_name_label";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getNameDescription(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_name_description";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<Types.TaskAllowedOperations> getAllowedOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_allowed_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfTaskAllowedOperations(v);
    }

    public Map<String, Types.TaskAllowedOperations> getCurrentOperations(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_current_operations";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringTaskAllowedOperations(v);
    }

    public Date getCreated(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_created";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toDate(v);
    }

    public Date getFinished(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_finished";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toDate(v);
    }

    public Types.TaskStatusType getStatus(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_status";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTaskStatusType(v);
    }

    public Host getResidentOn(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_resident_on";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toHost(v);
    }

    public Double getProgress(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_progress";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toDouble(v);
    }

    public String getType(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_type";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public String getResult(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_result";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toString(v);
    }

    public Set<String> getErrorInfo(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_error_info";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfString(v);
    }

    public Map<String, String> getOtherConfig(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfStringString(v);
    }

    public Task getSubtaskOf(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_subtask_of";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public Set<Task> getSubtasks(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_subtasks";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfTask(v);
    }

    public void setOtherConfig(Connection connection, Map<String, String> map) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.set_other_config";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(map)};
        Map map2 = connection.dispatch(string, objectArray);
    }

    public void addToOtherConfig(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "task.add_to_other_config";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
    }

    public void removeFromOtherConfig(Connection connection, String string) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string2 = "task.remove_from_other_config";
        String string3 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string3), Marshalling.toXMLRPC(this.ref), Marshalling.toXMLRPC(string)};
        Map map = connection.dispatch(string2, objectArray);
    }

    public static Task create(Connection connection, String string, String string2) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string3 = "task.create";
        String string4 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string4), Marshalling.toXMLRPC(string), Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string3, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void destroy(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.destroy";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public Task cancelAsync(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.OperationNotAllowed {
        String string = "Async.task.cancel";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toTask(v);
    }

    public void cancel(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException, Types.OperationNotAllowed {
        String string = "task.cancel";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2), Marshalling.toXMLRPC(this.ref)};
        Map map = connection.dispatch(string, objectArray);
    }

    public static Set<Task> getAll(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_all";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toSetOfTask(v);
    }

    public static Map<Task, Record> getAllRecords(Connection connection) throws Types.BadServerResponse, Types.XenAPIException, XmlRpcException {
        String string = "task.get_all_records";
        String string2 = connection.getSessionReference();
        Object[] objectArray = new Object[]{Marshalling.toXMLRPC(string2)};
        Map map = connection.dispatch(string, objectArray);
        Object v = map.get("Value");
        return Types.toMapOfTaskTaskRecord(v);
    }

    public static class Record
    implements Types.Record {
        public String uuid;
        public String nameLabel;
        public String nameDescription;
        public Set<Types.TaskAllowedOperations> allowedOperations;
        public Map<String, Types.TaskAllowedOperations> currentOperations;
        public Date created;
        public Date finished;
        public Types.TaskStatusType status;
        public Host residentOn;
        public Double progress;
        public String type;
        public String result;
        public Set<String> errorInfo;
        public Map<String, String> otherConfig;
        public Task subtaskOf;
        public Set<Task> subtasks;

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%1$20s: %2$s\n", "uuid", this.uuid);
            printWriter.printf("%1$20s: %2$s\n", "nameLabel", this.nameLabel);
            printWriter.printf("%1$20s: %2$s\n", "nameDescription", this.nameDescription);
            printWriter.printf("%1$20s: %2$s\n", "allowedOperations", this.allowedOperations);
            printWriter.printf("%1$20s: %2$s\n", "currentOperations", this.currentOperations);
            printWriter.printf("%1$20s: %2$s\n", "created", this.created);
            printWriter.printf("%1$20s: %2$s\n", "finished", this.finished);
            printWriter.printf("%1$20s: %2$s\n", new Object[]{"status", this.status});
            printWriter.printf("%1$20s: %2$s\n", "residentOn", this.residentOn);
            printWriter.printf("%1$20s: %2$s\n", "progress", this.progress);
            printWriter.printf("%1$20s: %2$s\n", "type", this.type);
            printWriter.printf("%1$20s: %2$s\n", "result", this.result);
            printWriter.printf("%1$20s: %2$s\n", "errorInfo", this.errorInfo);
            printWriter.printf("%1$20s: %2$s\n", "otherConfig", this.otherConfig);
            printWriter.printf("%1$20s: %2$s\n", "subtaskOf", this.subtaskOf);
            printWriter.printf("%1$20s: %2$s\n", "subtasks", this.subtasks);
            return stringWriter.toString();
        }

        @Override
        public Map<String, Object> toMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("uuid", this.uuid == null ? "" : this.uuid);
            hashMap.put("name_label", this.nameLabel == null ? "" : this.nameLabel);
            hashMap.put("name_description", this.nameDescription == null ? "" : this.nameDescription);
            hashMap.put("allowed_operations", this.allowedOperations == null ? new LinkedHashSet() : this.allowedOperations);
            hashMap.put("current_operations", this.currentOperations == null ? new HashMap() : this.currentOperations);
            hashMap.put("created", this.created == null ? new Date(0L) : this.created);
            hashMap.put("finished", this.finished == null ? new Date(0L) : this.finished);
            hashMap.put("status", (Object)(this.status == null ? Types.TaskStatusType.UNRECOGNIZED : this.status));
            hashMap.put("resident_on", this.residentOn == null ? new Host("OpaqueRef:NULL") : this.residentOn);
            hashMap.put("progress", this.progress == null ? 0.0 : this.progress);
            hashMap.put("type", this.type == null ? "" : this.type);
            hashMap.put("result", this.result == null ? "" : this.result);
            hashMap.put("error_info", this.errorInfo == null ? new LinkedHashSet() : this.errorInfo);
            hashMap.put("other_config", this.otherConfig == null ? new HashMap() : this.otherConfig);
            hashMap.put("subtask_of", this.subtaskOf == null ? new Task("OpaqueRef:NULL") : this.subtaskOf);
            hashMap.put("subtasks", this.subtasks == null ? new LinkedHashSet() : this.subtasks);
            return hashMap;
        }
    }
}

