10 PRINT "PROGRAM FILE 139: PERMUTATION TEST FOR THE RND FUNCTION."
20 PRINT "    ANSI STANDARD 8.4"
30 PRINT
40 PRINT "SECTION 139.1: PERMUTATION TEST FOR THE RND FUNCTION."
50 PRINT
60 PRINT "THIS PROGRAM TESTS TO SEE THAT WITHIN FIXED SIZE GROUPS"
70 PRINT "OF RANDOM NUMBERS, ALL ORDERS OF THE VALUES ARE EQUALLY"
80 PRINT "PROBABLE. CHI-SQUARE IS COMPUTED AND DISPLAYED TO SEE"
90 PRINT "WHETHER THE RESULTS ARE COMPATIBLE WITH THE EXPECTED"
100 PRINT "EXPECTED DISTRIBUTION FOR UNIFORM RANDOM NUMBERS."
110 PRINT
120 PRINT "***** THIS TEST IS INFORMATIVE ONLY *****"
130 PRINT
140 PRINT "                 BEGIN TEST"
150 PRINT
160 DIM C(25)
170 REM SET SIZE OF GROUP:
180 LET T=4
190 LET T1=1
200 REM T1=T1
210 FOR I=2 TO T
220 LET T1=T1*I
230 NEXT I
240 REM SET #TRIALS
250 LET N=10*T1
260 FOR I=0 TO T1
270 LET C(I)=0
280 NEXT I
290 FOR N1=1 TO N
300 LET A=0
310 LET K=1
320 FOR I=1 TO T
330 LET B(I)=RND
340 NEXT I
350 FOR R=T TO 1 STEP -1
360 LET M1=-1
370 REM FIND MAX OF REMAINDER OF THIS GROUP
380 FOR I=1 TO R
390 IF B(I)<M1 THEN 420
400 LET M1=B(I)
410 LET S=I
420 NEXT I
430 LET A=A+((S-1)*K)
440 LET K=K*R
450 LET B(S)=B(R)
460 NEXT R
470 REM VARIABLE A IS AN INTEGER, 0<=A<=T1, UNIQUELY SPECIFYING
480 REM THE ORDERING OF THIS GROUP.
490 LET C(A)=C(A)+1
500 NEXT N1
510 LET S=0
520 PRINT
530 PRINT "ORDER ID","ACTUAL COUNT"
540 PRINT "(EXPECTED COUNT = 10 FOR ALL CASES.)"
550 PRINT
560 FOR I=0 TO T1-1
570 LET S=S+(C(I)*C(I)*T1)
580 PRINT I,C(I)
590 NEXT I
600 LET V=(S/N) - N
605 PRINT
610 PRINT "FOR 23 D.F., SHOULD HAVE 13.0905 <= CHI-SQ <= 35.1725"
620 PRINT "(5% TAIL AT EACH END.)"
630 PRINT
640 PRINT "ACTUAL CHI-SQ = ";V
650 PRINT
660 IF V<13.0905 THEN 700
670 IF V>35.1725 THEN 700
680 PRINT "*** INFORMATIVE TEST PASSED ***"
690 GOTO 710
700 PRINT "*** INFORMATIVE TEST FAILED ***"
710 PRINT
720 PRINT "                   END TEST"
730 PRINT
740 PRINT "END PROGRAM 139"
750 END
