#if 0
gcc -s -O2 -o ./google google.c `curl-config --libs`
exit
#endif

// You can tell bystand to call this program to download messages from Google Groups.
// See the section about external protocols in bystand.doc for details.
// (Unfortunately, the messages may be a bit mangled, due to spam prevention.)

#include <curl/curl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define GOOGLE_URL_MSGID_PREFIX "https://groups.google.com/groups?selm="
#define GOOGLE_URL_SECOND_PREFIX "https://groups.google.com/forum/#!msg/"
#define GOOGLE_URL_RAW_PREFIX "https://groups.google.com/forum/message/raw?msg="

static char buf[2048];
static int args[8];
static int nargs;
static int a_state;

static size_t null_write_cb(char*ptr,size_t size,size_t nmemb,void*userdata) {
  return size*nmemb;
}

static size_t news_write_cb(char*ptr,size_t size,size_t nmemb,void*userdata) {
  char*end;
  size*=nmemb;
  end=ptr+size;
  while(ptr<end) {
    if(*ptr=='.' && !a_state) putchar('.');
    if(*ptr=='\n') putchar('\r');
    if(*ptr && *ptr!='\r') putchar(*ptr);
    a_state=(*ptr!='\n');
    ptr++;
  }
  return size;
}

static size_t header_cb(char*ptr,size_t size,size_t nmemb,void*userdata) {
  size*=nmemb;
  if(size<13 || strncasecmp(ptr,"HTTP/",5)) return size;
  ptr+=9;
  if(ptr[0]=='2' && ptr[1]=='0' && ptr[2]=='0') {
    printf("220 0 <%s>\r\n",(char*)userdata);
    return size;
  } else {
    printf("403 Got HTTP status code: %c%c%c\r\n",ptr[0],ptr[1],ptr[2]);
    return 0;
  }
}

static void download_article(const char*article_id) {
  char*mid=strdup(article_id+1);
  char*p;
  CURL*curl=0;
  int i;
  if(!mid) {
    printf("403 Memory allocation error\r\n");
    return;
  }
  p=strchr(mid,'>');
  if(!p) {
    printf("501 Bad argument\r\n");
    goto done;
  }
  *p=0;
  curl=curl_easy_init();
  if(!curl) {
    printf("403 curl_easy_init() failed\r\n");
    goto done;
  }
  p=curl_easy_escape(curl,mid,0);
  if(!p) {
    printf("403 curl_easy_escape() failed\r\n");
    goto done;
  }
  snprintf(buf,2047,"%s%s",GOOGLE_URL_MSGID_PREFIX,p);
  curl_free(p);
  if(i=curl_easy_setopt(curl,CURLOPT_URL,buf)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_FOLLOWLOCATION,(long)1)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_NOBODY,(long)1)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_NOPROGRESS,(long)1)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_REDIR_PROTOCOLS,(long)(CURLPROTO_HTTP|CURLPROTO_HTTPS))) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_MAXREDIRS,(long)4)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_WRITEFUNCTION,null_write_cb)) goto badopt;
  if(i=curl_easy_perform(curl)) {
    printf("403 Initial request failed (%d)\r\n",i);
    goto done;
  }
  if((i=curl_easy_getinfo(curl,CURLINFO_EFFECTIVE_URL,&p)) || !p) {
    printf("403 Failed to find effective URL of target (%d)\r\n",i);
    goto done;
  }
  if(strncmp(p,GOOGLE_URL_SECOND_PREFIX,sizeof(GOOGLE_URL_SECOND_PREFIX)-1)) {
    printf("403 Unexpected redirect target\r\n");
    goto done;
  }
  snprintf(buf,2047,"%s%s",GOOGLE_URL_RAW_PREFIX,p+sizeof(GOOGLE_URL_SECOND_PREFIX)-1);
  if(i=curl_easy_setopt(curl,CURLOPT_URL,buf)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_HTTPGET,(long)1)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_MAXREDIRS,(long)2)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_WRITEFUNCTION,news_write_cb)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_HEADERFUNCTION,header_cb)) goto badopt;
  if(i=curl_easy_setopt(curl,CURLOPT_HEADERDATA,mid)) goto badopt;
  a_state=0;
  if(i=curl_easy_perform(curl)) {
    if(i!=CURLE_WRITE_ERROR) printf("403 Final request failed (%d)\r\n",i);
    goto done;
  }
  if(a_state) printf("\r\n");
  printf(".\r\n");
  done:
  curl_easy_cleanup(curl);
  free(mid);
  return;
  badopt:
  printf("403 curl_easy_setopt() returned %d\r\n",i);
  goto done;
}

int main(int argc,char**argv) {
  int i;
  setbuf(stdin,0);
  setbuf(stdout,0);
  if(i=curl_global_init(CURL_GLOBAL_ALL)) {
    printf("400 Failed to initialize libcurl (error code %d)\r\n",i);
    return 1;
  }
  printf("201 Ready\r\n");
  while(fgets(buf,1500,stdin)) {
    i=strlen(buf);
    if(i && buf[i-1]=='\n') {
      buf[--i]=0;
    } else {
      while((i=getchar())!=EOF) if(i=='\n') break;
      if(i==EOF) return 0;
      printf("501 Command too long\r\n");
    }
    if(i && buf[i-1]=='\r') buf[--i]=0;
    while(i && (buf[i-1]==' ' || buf[i-1]=='\t')) buf[--i]=0;
    nargs=0;
    i=0;
    while(buf[i] && buf[i]!=' ' && buf[i]!='\t') {
      if(buf[i]>='a' && buf[i]<='z') buf[i]+='A'-'a';
      i++;
    }
    while(buf[i] && nargs<8) {
      while(buf[i]==' ' || buf[i]=='\t') buf[i++]=0;
      args[nargs++]=i;
      while(buf[i] && buf[i]!=' ' && buf[i]!='\t') i++;
      if(buf[i]) buf[i++]=0;
    }
    if(!strcmp(buf,"ARTICLE")) {
      if(nargs!=1 || buf[args[0]]!='<') goto badargs;
      download_article(buf+args[0]);
    } else if(!strcmp(buf,"CAPABILITIES")) {
      if(nargs) goto badargs;
      printf("101 Capabilities:\r\nVERSION 2\r\nREADER\r\nIMPLEMENTATION Google Groups downloader\r\n.\r\n");
    } else if(!strcmp(buf,"QUIT")) {
      if(nargs) goto badargs;
      printf("205 Goodbye\r\n");
      return 0;
    } else {
      printf("500 Unknown command: %s\r\n",buf);
    }
    continue;
    badargs: printf("501 Bad arguments\r\n");
  }
  return 0;
}
