/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPreflight;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.WriterReportImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.ZipFile;

public class Preflight {
    public static final String VERSION = "0.1.0";
    File epubFile;
    Report userReport;
    int warningCount;
    int errorCount;

    static String fixMessage(String message) {
        return message.replaceAll("\r\n", " ").replaceAll("\r", " ").replaceAll("\n", " ");
    }

    public Preflight(File epubFile) {
        this.epubFile = epubFile;
        this.userReport = new DefaultReportImpl(epubFile.getName());
    }

    public Preflight(File epubFile, PrintWriter out) {
        this.epubFile = epubFile;
        this.userReport = new WriterReportImpl(out);
    }

    public Preflight(File epubFile, Report report) {
        this.epubFile = epubFile;
        this.userReport = report;
    }

    public boolean validate() {
        ProxyReport report = new ProxyReport();
        try {
            FileInputStream epubIn = new FileInputStream(this.epubFile);
            byte[] header = new byte[58];
            if (epubIn.read(header) != header.length) {
                report.error(null, 0, "cannot read header");
            } else if (header[0] != 80 && header[1] != 75) {
                report.error(null, 0, "corrupted ZIP header");
            } else if (!CheckUtil.checkString(header, 30, "mimetype")) {
                report.error(null, 0, "mimetype entry missing or not the first in archive");
            } else if (!CheckUtil.checkString(header, 38, "application/epub+zip")) {
                report.error(null, 0, "mimetype contains wrong type (application/epub+zip expected)");
            }
            epubIn.close();
            ZipFile zip = new ZipFile(this.epubFile);
            OCFPreflight checker = new OCFPreflight(zip, report);
            checker.runChecks();
            zip.close();
        }
        catch (IOException e) {
            report.error(null, 0, "I/O error: " + e.getMessage());
        }
        return this.warningCount == 0 && this.errorCount == 0;
    }

    class ProxyReport
    implements Report {
        ProxyReport() {
        }

        public void error(String resource, int line, String message) {
            ++Preflight.this.errorCount;
            Preflight.this.userReport.error(resource, line, Preflight.fixMessage(message));
        }

        public void warning(String resource, int line, String message) {
            ++Preflight.this.warningCount;
            Preflight.this.userReport.warning(resource, line, Preflight.fixMessage(message));
        }
    }
}

