package cloudauth_console

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadIdentifyRecord invokes the cloudauth_console.UploadIdentifyRecord API synchronously
func (client *Client) UploadIdentifyRecord(request *UploadIdentifyRecordRequest) (response *UploadIdentifyRecordResponse, err error) {
	response = CreateUploadIdentifyRecordResponse()
	err = client.DoAction(request, response)
	return
}

// UploadIdentifyRecordWithChan invokes the cloudauth_console.UploadIdentifyRecord API asynchronously
func (client *Client) UploadIdentifyRecordWithChan(request *UploadIdentifyRecordRequest) (<-chan *UploadIdentifyRecordResponse, <-chan error) {
	responseChan := make(chan *UploadIdentifyRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadIdentifyRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadIdentifyRecordWithCallback invokes the cloudauth_console.UploadIdentifyRecord API asynchronously
func (client *Client) UploadIdentifyRecordWithCallback(request *UploadIdentifyRecordRequest, callback func(response *UploadIdentifyRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadIdentifyRecordResponse
		var err error
		defer close(result)
		response, err = client.UploadIdentifyRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadIdentifyRecordRequest is the request struct for api UploadIdentifyRecord
type UploadIdentifyRecordRequest struct {
	*requests.RpcRequest
	Ext                    string           `position:"Query" name:"Ext"`
	IdentifyingImageUrl    string           `position:"Query" name:"IdentifyingImageUrl"`
	IdentifyingImageBase64 string           `position:"Body" name:"IdentifyingImageBase64"`
	DeviceSecret           string           `position:"Query" name:"DeviceSecret"`
	ProductKey             string           `position:"Query" name:"ProductKey"`
	UserId                 string           `position:"Query" name:"UserId"`
	IotId                  string           `position:"Query" name:"IotId"`
	DeviceName             string           `position:"Query" name:"DeviceName"`
	IdentifyingTime        requests.Integer `position:"Query" name:"IdentifyingTime"`
	ProjectId              string           `position:"Query" name:"ProjectId"`
	UserName               string           `position:"Query" name:"UserName"`
}

// UploadIdentifyRecordResponse is the response struct for api UploadIdentifyRecord
type UploadIdentifyRecordResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateUploadIdentifyRecordRequest creates a request to invoke UploadIdentifyRecord API
func CreateUploadIdentifyRecordRequest() (request *UploadIdentifyRecordRequest) {
	request = &UploadIdentifyRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth-console", "2019-04-03", "UploadIdentifyRecord", "cloudauth-console", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUploadIdentifyRecordResponse creates a response to parse from UploadIdentifyRecord response
func CreateUploadIdentifyRecordResponse() (response *UploadIdentifyRecordResponse) {
	response = &UploadIdentifyRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
