package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobGroupsWithScenario invokes the cloudcallcenter.ListJobGroupsWithScenario API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listjobgroupswithscenario.html
func (client *Client) ListJobGroupsWithScenario(request *ListJobGroupsWithScenarioRequest) (response *ListJobGroupsWithScenarioResponse, err error) {
	response = CreateListJobGroupsWithScenarioResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobGroupsWithScenarioWithChan invokes the cloudcallcenter.ListJobGroupsWithScenario API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listjobgroupswithscenario.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobGroupsWithScenarioWithChan(request *ListJobGroupsWithScenarioRequest) (<-chan *ListJobGroupsWithScenarioResponse, <-chan error) {
	responseChan := make(chan *ListJobGroupsWithScenarioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobGroupsWithScenario(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobGroupsWithScenarioWithCallback invokes the cloudcallcenter.ListJobGroupsWithScenario API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listjobgroupswithscenario.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobGroupsWithScenarioWithCallback(request *ListJobGroupsWithScenarioRequest, callback func(response *ListJobGroupsWithScenarioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobGroupsWithScenarioResponse
		var err error
		defer close(result)
		response, err = client.ListJobGroupsWithScenario(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobGroupsWithScenarioRequest is the request struct for api ListJobGroupsWithScenario
type ListJobGroupsWithScenarioRequest struct {
	*requests.RpcRequest
	EndTime    requests.Integer `position:"Query" name:"EndTime"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListJobGroupsWithScenarioResponse is the response struct for api ListJobGroupsWithScenario
type ListJobGroupsWithScenarioResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	Success        bool      `json:"Success" xml:"Success"`
	Code           string    `json:"Code" xml:"Code"`
	Message        string    `json:"Message" xml:"Message"`
	HttpStatusCode int       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	JobGroups      JobGroups `json:"JobGroups" xml:"JobGroups"`
}

// CreateListJobGroupsWithScenarioRequest creates a request to invoke ListJobGroupsWithScenario API
func CreateListJobGroupsWithScenarioRequest() (request *ListJobGroupsWithScenarioRequest) {
	request = &ListJobGroupsWithScenarioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListJobGroupsWithScenario", "", "")
	request.Method = requests.POST
	return
}

// CreateListJobGroupsWithScenarioResponse creates a response to parse from ListJobGroupsWithScenario response
func CreateListJobGroupsWithScenarioResponse() (response *ListJobGroupsWithScenarioResponse) {
	response = &ListJobGroupsWithScenarioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
