package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaobaoOrder invokes the cloudcallcenter.UpdateTaobaoOrder API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaoorder.html
func (client *Client) UpdateTaobaoOrder(request *UpdateTaobaoOrderRequest) (response *UpdateTaobaoOrderResponse, err error) {
	response = CreateUpdateTaobaoOrderResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaobaoOrderWithChan invokes the cloudcallcenter.UpdateTaobaoOrder API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaoorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTaobaoOrderWithChan(request *UpdateTaobaoOrderRequest) (<-chan *UpdateTaobaoOrderResponse, <-chan error) {
	responseChan := make(chan *UpdateTaobaoOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaobaoOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaobaoOrderWithCallback invokes the cloudcallcenter.UpdateTaobaoOrder API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/updatetaobaoorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTaobaoOrderWithCallback(request *UpdateTaobaoOrderRequest, callback func(response *UpdateTaobaoOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaobaoOrderResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaobaoOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaobaoOrderRequest is the request struct for api UpdateTaobaoOrder
type UpdateTaobaoOrderRequest struct {
	*requests.RpcRequest
	Order *[]UpdateTaobaoOrderOrder `position:"Query" name:"Order"  type:"Repeated"`
}

// UpdateTaobaoOrderOrder is a repeated param struct in UpdateTaobaoOrderRequest
type UpdateTaobaoOrderOrder struct {
	ConfirmedAccount         string `name:"confirmedAccount"`
	ConsumedOutcomingAccount string `name:"consumedOutcomingAccount"`
	Id                       string `name:"id"`
	LastCalculateTime        string `name:"lastCalculateTime"`
	ConsumedIncomingAccount  string `name:"consumedIncomingAccount"`
	Status                   string `name:"Status"`
}

// UpdateTaobaoOrderResponse is the response struct for api UpdateTaobaoOrder
type UpdateTaobaoOrderResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Count          int    `json:"Count" xml:"Count"`
}

// CreateUpdateTaobaoOrderRequest creates a request to invoke UpdateTaobaoOrder API
func CreateUpdateTaobaoOrderRequest() (request *UpdateTaobaoOrderRequest) {
	request = &UpdateTaobaoOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "UpdateTaobaoOrder", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTaobaoOrderResponse creates a response to parse from UpdateTaobaoOrder response
func CreateUpdateTaobaoOrderResponse() (response *UpdateTaobaoOrderResponse) {
	response = &UpdateTaobaoOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
