package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPhotos invokes the cloudphoto.ListPhotos API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotos.html
func (client *Client) ListPhotos(request *ListPhotosRequest) (response *ListPhotosResponse, err error) {
	response = CreateListPhotosResponse()
	err = client.DoAction(request, response)
	return
}

// ListPhotosWithChan invokes the cloudphoto.ListPhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPhotosWithChan(request *ListPhotosRequest) (<-chan *ListPhotosResponse, <-chan error) {
	responseChan := make(chan *ListPhotosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPhotos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPhotosWithCallback invokes the cloudphoto.ListPhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPhotosWithCallback(request *ListPhotosRequest, callback func(response *ListPhotosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPhotosResponse
		var err error
		defer close(result)
		response, err = client.ListPhotos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPhotosRequest is the request struct for api ListPhotos
type ListPhotosRequest struct {
	*requests.RpcRequest
	Cursor    string           `position:"Query" name:"Cursor"`
	Size      requests.Integer `position:"Query" name:"Size"`
	LibraryId string           `position:"Query" name:"LibraryId"`
	StoreName string           `position:"Query" name:"StoreName"`
	State     string           `position:"Query" name:"State"`
	Direction string           `position:"Query" name:"Direction"`
}

// ListPhotosResponse is the response struct for api ListPhotos
type ListPhotosResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	NextCursor string  `json:"NextCursor" xml:"NextCursor"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	Action     string  `json:"Action" xml:"Action"`
	Photos     []Photo `json:"Photos" xml:"Photos"`
}

// CreateListPhotosRequest creates a request to invoke ListPhotos API
func CreateListPhotosRequest() (request *ListPhotosRequest) {
	request = &ListPhotosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "ListPhotos", "cloudphoto", "openAPI")
	return
}

// CreateListPhotosResponse creates a response to parse from ListPhotos response
func CreateListPhotosResponse() (response *ListPhotosResponse) {
	response = &ListPhotosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
