package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ProduceInstance invokes the cloudwf.ProduceInstance API synchronously
// api document: https://help.aliyun.com/api/cloudwf/produceinstance.html
func (client *Client) ProduceInstance(request *ProduceInstanceRequest) (response *ProduceInstanceResponse, err error) {
	response = CreateProduceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ProduceInstanceWithChan invokes the cloudwf.ProduceInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/produceinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProduceInstanceWithChan(request *ProduceInstanceRequest) (<-chan *ProduceInstanceResponse, <-chan error) {
	responseChan := make(chan *ProduceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ProduceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ProduceInstanceWithCallback invokes the cloudwf.ProduceInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/produceinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ProduceInstanceWithCallback(request *ProduceInstanceRequest, callback func(response *ProduceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ProduceInstanceResponse
		var err error
		defer close(result)
		response, err = client.ProduceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ProduceInstanceRequest is the request struct for api ProduceInstance
type ProduceInstanceRequest struct {
	*requests.RpcRequest
	TraceId          string `position:"Query" name:"TraceId"`
	ProduceParameter string `position:"Query" name:"ProduceParameter"`
}

// ProduceInstanceResponse is the response struct for api ProduceInstance
type ProduceInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"success" xml:"success"`
	Message   string `json:"message" xml:"message"`
	Result    string `json:"result" xml:"result"`
}

// CreateProduceInstanceRequest creates a request to invoke ProduceInstance API
func CreateProduceInstanceRequest() (request *ProduceInstanceRequest) {
	request = &ProduceInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ProduceInstance", "cloudwf", "openAPI")
	return
}

// CreateProduceInstanceResponse creates a response to parse from ProduceInstance response
func CreateProduceInstanceResponse() (response *ProduceInstanceResponse) {
	response = &ProduceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
