package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopSetfiltermac invokes the cloudwf.ShopSetfiltermac API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopsetfiltermac.html
func (client *Client) ShopSetfiltermac(request *ShopSetfiltermacRequest) (response *ShopSetfiltermacResponse, err error) {
	response = CreateShopSetfiltermacResponse()
	err = client.DoAction(request, response)
	return
}

// ShopSetfiltermacWithChan invokes the cloudwf.ShopSetfiltermac API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopsetfiltermac.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopSetfiltermacWithChan(request *ShopSetfiltermacRequest) (<-chan *ShopSetfiltermacResponse, <-chan error) {
	responseChan := make(chan *ShopSetfiltermacResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopSetfiltermac(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopSetfiltermacWithCallback invokes the cloudwf.ShopSetfiltermac API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopsetfiltermac.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopSetfiltermacWithCallback(request *ShopSetfiltermacRequest, callback func(response *ShopSetfiltermacResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopSetfiltermacResponse
		var err error
		defer close(result)
		response, err = client.ShopSetfiltermac(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopSetfiltermacRequest is the request struct for api ShopSetfiltermac
type ShopSetfiltermacRequest struct {
	*requests.RpcRequest
	Mac string           `position:"Query" name:"Mac"`
	Sid requests.Integer `position:"Query" name:"Sid"`
}

// ShopSetfiltermacResponse is the response struct for api ShopSetfiltermac
type ShopSetfiltermacResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopSetfiltermacRequest creates a request to invoke ShopSetfiltermac API
func CreateShopSetfiltermacRequest() (request *ShopSetfiltermacRequest) {
	request = &ShopSetfiltermacRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopSetfiltermac", "cloudwf", "openAPI")
	return
}

// CreateShopSetfiltermacResponse creates a response to parse from ShopSetfiltermac response
func CreateShopSetfiltermacResponse() (response *ShopSetfiltermacResponse) {
	response = &ShopSetfiltermacResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
