package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceInstances invokes the eas.DeleteResourceInstances API synchronously
func (client *Client) DeleteResourceInstances(request *DeleteResourceInstancesRequest) (response *DeleteResourceInstancesResponse, err error) {
	response = CreateDeleteResourceInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceInstancesWithChan invokes the eas.DeleteResourceInstances API asynchronously
func (client *Client) DeleteResourceInstancesWithChan(request *DeleteResourceInstancesRequest) (<-chan *DeleteResourceInstancesResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceInstancesWithCallback invokes the eas.DeleteResourceInstances API asynchronously
func (client *Client) DeleteResourceInstancesWithCallback(request *DeleteResourceInstancesRequest, callback func(response *DeleteResourceInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceInstancesResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceInstancesRequest is the request struct for api DeleteResourceInstances
type DeleteResourceInstancesRequest struct {
	*requests.RoaRequest
	InstanceList string           `position:"Query" name:"InstanceList"`
	ResourceId   string           `position:"Path" name:"ResourceId"`
	AllFailed    requests.Boolean `position:"Query" name:"AllFailed"`
	ClusterId    string           `position:"Path" name:"ClusterId"`
}

// DeleteResourceInstancesResponse is the response struct for api DeleteResourceInstances
type DeleteResourceInstancesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteResourceInstancesRequest creates a request to invoke DeleteResourceInstances API
func CreateDeleteResourceInstancesRequest() (request *DeleteResourceInstancesRequest) {
	request = &DeleteResourceInstancesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DeleteResourceInstances", "/api/v2/resources/[ClusterId]/[ResourceId]/instances", "eas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteResourceInstancesResponse creates a response to parse from DeleteResourceInstances response
func CreateDeleteResourceInstancesResponse() (response *DeleteResourceInstancesResponse) {
	response = &DeleteResourceInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
