package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccessWhiteListSlbList invokes the jarvis.DescribeAccessWhiteListSlbList API synchronously
// api document: https://help.aliyun.com/api/jarvis/describeaccesswhitelistslblist.html
func (client *Client) DescribeAccessWhiteListSlbList(request *DescribeAccessWhiteListSlbListRequest) (response *DescribeAccessWhiteListSlbListResponse, err error) {
	response = CreateDescribeAccessWhiteListSlbListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccessWhiteListSlbListWithChan invokes the jarvis.DescribeAccessWhiteListSlbList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeaccesswhitelistslblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccessWhiteListSlbListWithChan(request *DescribeAccessWhiteListSlbListRequest) (<-chan *DescribeAccessWhiteListSlbListResponse, <-chan error) {
	responseChan := make(chan *DescribeAccessWhiteListSlbListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccessWhiteListSlbList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccessWhiteListSlbListWithCallback invokes the jarvis.DescribeAccessWhiteListSlbList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeaccesswhitelistslblist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccessWhiteListSlbListWithCallback(request *DescribeAccessWhiteListSlbListRequest, callback func(response *DescribeAccessWhiteListSlbListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccessWhiteListSlbListResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccessWhiteListSlbList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccessWhiteListSlbListRequest is the request struct for api DescribeAccessWhiteListSlbList
type DescribeAccessWhiteListSlbListRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
	SourceCode string `position:"Query" name:"SourceCode"`
}

// DescribeAccessWhiteListSlbListResponse is the response struct for api DescribeAccessWhiteListSlbList
type DescribeAccessWhiteListSlbListResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	Module     string `json:"module" xml:"module"`
	SlbList    []Ecs  `json:"SlbList" xml:"SlbList"`
}

// CreateDescribeAccessWhiteListSlbListRequest creates a request to invoke DescribeAccessWhiteListSlbList API
func CreateDescribeAccessWhiteListSlbListRequest() (request *DescribeAccessWhiteListSlbListRequest) {
	request = &DescribeAccessWhiteListSlbListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeAccessWhiteListSlbList", "jarvis", "openAPI")
	return
}

// CreateDescribeAccessWhiteListSlbListResponse creates a response to parse from DescribeAccessWhiteListSlbList response
func CreateDescribeAccessWhiteListSlbListResponse() (response *DescribeAccessWhiteListSlbListResponse) {
	response = &DescribeAccessWhiteListSlbListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
