package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshProxyLevel invokes the polardb.RefreshProxyLevel API synchronously
func (client *Client) RefreshProxyLevel(request *RefreshProxyLevelRequest) (response *RefreshProxyLevelResponse, err error) {
	response = CreateRefreshProxyLevelResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshProxyLevelWithChan invokes the polardb.RefreshProxyLevel API asynchronously
func (client *Client) RefreshProxyLevelWithChan(request *RefreshProxyLevelRequest) (<-chan *RefreshProxyLevelResponse, <-chan error) {
	responseChan := make(chan *RefreshProxyLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshProxyLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshProxyLevelWithCallback invokes the polardb.RefreshProxyLevel API asynchronously
func (client *Client) RefreshProxyLevelWithCallback(request *RefreshProxyLevelRequest, callback func(response *RefreshProxyLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshProxyLevelResponse
		var err error
		defer close(result)
		response, err = client.RefreshProxyLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshProxyLevelRequest is the request struct for api RefreshProxyLevel
type RefreshProxyLevelRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PlannedEndTime       string           `position:"Query" name:"PlannedEndTime"`
	ProxyTargetClass     string           `position:"Query" name:"ProxyTargetClass"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PlannedStartTime     string           `position:"Query" name:"PlannedStartTime"`
	FromTimeService      requests.Boolean `position:"Query" name:"FromTimeService"`
}

// RefreshProxyLevelResponse is the response struct for api RefreshProxyLevel
type RefreshProxyLevelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRefreshProxyLevelRequest creates a request to invoke RefreshProxyLevel API
func CreateRefreshProxyLevelRequest() (request *RefreshProxyLevelRequest) {
	request = &RefreshProxyLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "RefreshProxyLevel", "", "")
	request.Method = requests.POST
	return
}

// CreateRefreshProxyLevelResponse creates a response to parse from RefreshProxyLevel response
func CreateRefreshProxyLevelResponse() (response *RefreshProxyLevelResponse) {
	response = &RefreshProxyLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
