package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TerminateMigrateTask invokes the rds.TerminateMigrateTask API synchronously
func (client *Client) TerminateMigrateTask(request *TerminateMigrateTaskRequest) (response *TerminateMigrateTaskResponse, err error) {
	response = CreateTerminateMigrateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// TerminateMigrateTaskWithChan invokes the rds.TerminateMigrateTask API asynchronously
func (client *Client) TerminateMigrateTaskWithChan(request *TerminateMigrateTaskRequest) (<-chan *TerminateMigrateTaskResponse, <-chan error) {
	responseChan := make(chan *TerminateMigrateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TerminateMigrateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TerminateMigrateTaskWithCallback invokes the rds.TerminateMigrateTask API asynchronously
func (client *Client) TerminateMigrateTaskWithCallback(request *TerminateMigrateTaskRequest, callback func(response *TerminateMigrateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TerminateMigrateTaskResponse
		var err error
		defer close(result)
		response, err = client.TerminateMigrateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TerminateMigrateTaskRequest is the request struct for api TerminateMigrateTask
type TerminateMigrateTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MigrateTaskId        string           `position:"Query" name:"MigrateTaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
}

// TerminateMigrateTaskResponse is the response struct for api TerminateMigrateTask
type TerminateMigrateTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateTerminateMigrateTaskRequest creates a request to invoke TerminateMigrateTask API
func CreateTerminateMigrateTaskRequest() (request *TerminateMigrateTaskRequest) {
	request = &TerminateMigrateTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "TerminateMigrateTask", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTerminateMigrateTaskResponse creates a response to parse from TerminateMigrateTask response
func CreateTerminateMigrateTaskResponse() (response *TerminateMigrateTaskResponse) {
	response = &TerminateMigrateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
