package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActivateGateway invokes the sgw.ActivateGateway API synchronously
func (client *Client) ActivateGateway(request *ActivateGatewayRequest) (response *ActivateGatewayResponse, err error) {
	response = CreateActivateGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// ActivateGatewayWithChan invokes the sgw.ActivateGateway API asynchronously
func (client *Client) ActivateGatewayWithChan(request *ActivateGatewayRequest) (<-chan *ActivateGatewayResponse, <-chan error) {
	responseChan := make(chan *ActivateGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActivateGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActivateGatewayWithCallback invokes the sgw.ActivateGateway API asynchronously
func (client *Client) ActivateGatewayWithCallback(request *ActivateGatewayRequest, callback func(response *ActivateGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActivateGatewayResponse
		var err error
		defer close(result)
		response, err = client.ActivateGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActivateGatewayRequest is the request struct for api ActivateGateway
type ActivateGatewayRequest struct {
	*requests.RpcRequest
	ClientUUID    string `position:"Query" name:"ClientUUID"`
	SerialNumber  string `position:"Query" name:"SerialNumber"`
	Type          string `position:"Query" name:"Type"`
	Token         string `position:"Query" name:"Token"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	Model         string `position:"Query" name:"Model"`
	Category      string `position:"Query" name:"Category"`
}

// ActivateGatewayResponse is the response struct for api ActivateGateway
type ActivateGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	GatewayId string `json:"GatewayId" xml:"GatewayId"`
	RegionId  string `json:"RegionId" xml:"RegionId"`
}

// CreateActivateGatewayRequest creates a request to invoke ActivateGateway API
func CreateActivateGatewayRequest() (request *ActivateGatewayRequest) {
	request = &ActivateGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ActivateGateway", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateActivateGatewayResponse creates a response to parse from ActivateGateway response
func CreateActivateGatewayResponse() (response *ActivateGatewayResponse) {
	response = &ActivateGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
