// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type ServiceIDTransportProtocol string

const (
	ServiceIDTransportProtocolUnknown ServiceIDTransportProtocol = ""
	ServiceIDTransportProtocolTCP     ServiceIDTransportProtocol = "tcp"
	ServiceIDTransportProtocolUDP     ServiceIDTransportProtocol = "udp"
	ServiceIDTransportProtocolIcmp    ServiceIDTransportProtocol = "icmp"
	ServiceIDTransportProtocolQuic    ServiceIDTransportProtocol = "quic"
)

func (e ServiceIDTransportProtocol) ToPointer() *ServiceIDTransportProtocol {
	return &e
}
func (e *ServiceIDTransportProtocol) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "tcp":
		fallthrough
	case "udp":
		fallthrough
	case "icmp":
		fallthrough
	case "quic":
		*e = ServiceIDTransportProtocol(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ServiceIDTransportProtocol: %v", v)
	}
}

type ServiceID struct {
	IP                *string                     `json:"ip,omitempty"`
	Port              *int                        `json:"port,omitempty"`
	Protocol          *string                     `json:"protocol,omitempty"`
	TransportProtocol *ServiceIDTransportProtocol `json:"transport_protocol,omitempty"`
}

func (o *ServiceID) GetIP() *string {
	if o == nil {
		return nil
	}
	return o.IP
}

func (o *ServiceID) GetPort() *int {
	if o == nil {
		return nil
	}
	return o.Port
}

func (o *ServiceID) GetProtocol() *string {
	if o == nil {
		return nil
	}
	return o.Protocol
}

func (o *ServiceID) GetTransportProtocol() *ServiceIDTransportProtocol {
	if o == nil {
		return nil
	}
	return o.TransportProtocol
}
