// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package operations

import (
	"github.com/censys/censys-sdk-go/internal/utils"
	"github.com/censys/censys-sdk-go/models/components"
	"time"
)

type V3GlobaldataAssetHostGlobals struct {
	OrganizationID *string `queryParam:"style=form,explode=true,name=organization_id"`
}

func (o *V3GlobaldataAssetHostGlobals) GetOrganizationID() *string {
	if o == nil {
		return nil
	}
	return o.OrganizationID
}

type V3GlobaldataAssetHostRequest struct {
	// The ID of a Censys organization to associate the request with. See the [Getting Started docs](https://docs.censys.com/reference/get-started#step-3-set-your-organization-id) for more information.
	OrganizationID *string `queryParam:"style=form,explode=false,name=organization_id"`
	// The IP address of a host.
	HostID string `pathParam:"style=simple,explode=false,name=host_id"`
	// RFC3339 Timestamp to view a host at a specific point in time. Must be a valid RFC3339 string. Ensure that you suffix the date with T00:00:00Z or a specific time.
	AtTime *time.Time `queryParam:"style=form,explode=false,name=at_time"`
}

func (v V3GlobaldataAssetHostRequest) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(v, "", false)
}

func (v *V3GlobaldataAssetHostRequest) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &v, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *V3GlobaldataAssetHostRequest) GetOrganizationID() *string {
	if o == nil {
		return nil
	}
	return o.OrganizationID
}

func (o *V3GlobaldataAssetHostRequest) GetHostID() string {
	if o == nil {
		return ""
	}
	return o.HostID
}

func (o *V3GlobaldataAssetHostRequest) GetAtTime() *time.Time {
	if o == nil {
		return nil
	}
	return o.AtTime
}

type V3GlobaldataAssetHostResponse struct {
	HTTPMeta components.HTTPMetadata `json:"-"`
	// OK
	ResponseEnvelopeHostAsset *components.ResponseEnvelopeHostAsset
	Headers                   map[string][]string
}

func (o *V3GlobaldataAssetHostResponse) GetHTTPMeta() components.HTTPMetadata {
	if o == nil {
		return components.HTTPMetadata{}
	}
	return o.HTTPMeta
}

func (o *V3GlobaldataAssetHostResponse) GetResponseEnvelopeHostAsset() *components.ResponseEnvelopeHostAsset {
	if o == nil {
		return nil
	}
	return o.ResponseEnvelopeHostAsset
}

func (o *V3GlobaldataAssetHostResponse) GetHeaders() map[string][]string {
	if o == nil {
		return map[string][]string{}
	}
	return o.Headers
}
