// Code generated by protoc-gen-go-aip. DO NOT EDIT.
//
// versions:
// 	protoc-gen-go-aip development
// 	protoc (unknown)
// source: coinbase/cloud/mpc_wallets/v1/mpc_wallets.proto

package v1

import (
	fmt "fmt"
	resourcename "go.einride.tech/aip/resourcename"
	strings "strings"
)

type MPCWalletResourceName struct {
	PoolId      string
	MpcWalletId string
}

func (n MPCWalletResourceName) Validate() error {
	if n.PoolId == "" {
		return fmt.Errorf("pool_id: empty")
	}
	if strings.IndexByte(n.PoolId, '/') != -1 {
		return fmt.Errorf("pool_id: contains illegal character '/'")
	}
	if n.MpcWalletId == "" {
		return fmt.Errorf("mpc_wallet_id: empty")
	}
	if strings.IndexByte(n.MpcWalletId, '/') != -1 {
		return fmt.Errorf("mpc_wallet_id: contains illegal character '/'")
	}
	return nil
}

func (n MPCWalletResourceName) ContainsWildcard() bool {
	return false || n.PoolId == "-" || n.MpcWalletId == "-"
}

func (n MPCWalletResourceName) String() string {
	return resourcename.Sprint(
		"pools/{pool_id}/mpcWallets/{mpc_wallet_id}",
		n.PoolId,
		n.MpcWalletId,
	)
}

func (n MPCWalletResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

func (n *MPCWalletResourceName) UnmarshalString(name string) error {
	return resourcename.Sscan(
		name,
		"pools/{pool_id}/mpcWallets/{mpc_wallet_id}",
		&n.PoolId,
		&n.MpcWalletId,
	)
}

type AddressResourceName struct {
	NetworkId string
	AddressId string
}

func (n AddressResourceName) Validate() error {
	if n.NetworkId == "" {
		return fmt.Errorf("network_id: empty")
	}
	if strings.IndexByte(n.NetworkId, '/') != -1 {
		return fmt.Errorf("network_id: contains illegal character '/'")
	}
	if n.AddressId == "" {
		return fmt.Errorf("address_id: empty")
	}
	if strings.IndexByte(n.AddressId, '/') != -1 {
		return fmt.Errorf("address_id: contains illegal character '/'")
	}
	return nil
}

func (n AddressResourceName) ContainsWildcard() bool {
	return false || n.NetworkId == "-" || n.AddressId == "-"
}

func (n AddressResourceName) String() string {
	return resourcename.Sprint(
		"networks/{network_id}/addresses/{address_id}",
		n.NetworkId,
		n.AddressId,
	)
}

func (n AddressResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

func (n *AddressResourceName) UnmarshalString(name string) error {
	return resourcename.Sscan(
		name,
		"networks/{network_id}/addresses/{address_id}",
		&n.NetworkId,
		&n.AddressId,
	)
}

type BalanceResourceName struct {
	NetworkId string
	AddressId string
	BalanceId string
}

func (n AddressResourceName) BalanceResourceName(
	balanceId string,
) BalanceResourceName {
	return BalanceResourceName{
		NetworkId: n.NetworkId,
		AddressId: n.AddressId,
		BalanceId: balanceId,
	}
}

func (n BalanceResourceName) Validate() error {
	if n.NetworkId == "" {
		return fmt.Errorf("network_id: empty")
	}
	if strings.IndexByte(n.NetworkId, '/') != -1 {
		return fmt.Errorf("network_id: contains illegal character '/'")
	}
	if n.AddressId == "" {
		return fmt.Errorf("address_id: empty")
	}
	if strings.IndexByte(n.AddressId, '/') != -1 {
		return fmt.Errorf("address_id: contains illegal character '/'")
	}
	if n.BalanceId == "" {
		return fmt.Errorf("balance_id: empty")
	}
	if strings.IndexByte(n.BalanceId, '/') != -1 {
		return fmt.Errorf("balance_id: contains illegal character '/'")
	}
	return nil
}

func (n BalanceResourceName) ContainsWildcard() bool {
	return false || n.NetworkId == "-" || n.AddressId == "-" || n.BalanceId == "-"
}

func (n BalanceResourceName) String() string {
	return resourcename.Sprint(
		"networks/{network_id}/addresses/{address_id}/balances/{balance_id}",
		n.NetworkId,
		n.AddressId,
		n.BalanceId,
	)
}

func (n BalanceResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

func (n *BalanceResourceName) UnmarshalString(name string) error {
	return resourcename.Sscan(
		name,
		"networks/{network_id}/addresses/{address_id}/balances/{balance_id}",
		&n.NetworkId,
		&n.AddressId,
		&n.BalanceId,
	)
}

func (n BalanceResourceName) AddressResourceName() AddressResourceName {
	return AddressResourceName{
		NetworkId: n.NetworkId,
		AddressId: n.AddressId,
	}
}

type BalanceDetailResourceName struct {
	NetworkId       string
	AddressId       string
	BalanceId       string
	BalanceDetailId string
}

func (n AddressResourceName) BalanceDetailResourceName(
	balanceId string,
	balanceDetailId string,
) BalanceDetailResourceName {
	return BalanceDetailResourceName{
		NetworkId:       n.NetworkId,
		AddressId:       n.AddressId,
		BalanceId:       balanceId,
		BalanceDetailId: balanceDetailId,
	}
}

func (n BalanceResourceName) BalanceDetailResourceName(
	balanceDetailId string,
) BalanceDetailResourceName {
	return BalanceDetailResourceName{
		NetworkId:       n.NetworkId,
		AddressId:       n.AddressId,
		BalanceId:       n.BalanceId,
		BalanceDetailId: balanceDetailId,
	}
}

func (n BalanceDetailResourceName) Validate() error {
	if n.NetworkId == "" {
		return fmt.Errorf("network_id: empty")
	}
	if strings.IndexByte(n.NetworkId, '/') != -1 {
		return fmt.Errorf("network_id: contains illegal character '/'")
	}
	if n.AddressId == "" {
		return fmt.Errorf("address_id: empty")
	}
	if strings.IndexByte(n.AddressId, '/') != -1 {
		return fmt.Errorf("address_id: contains illegal character '/'")
	}
	if n.BalanceId == "" {
		return fmt.Errorf("balance_id: empty")
	}
	if strings.IndexByte(n.BalanceId, '/') != -1 {
		return fmt.Errorf("balance_id: contains illegal character '/'")
	}
	if n.BalanceDetailId == "" {
		return fmt.Errorf("balance_detail_id: empty")
	}
	if strings.IndexByte(n.BalanceDetailId, '/') != -1 {
		return fmt.Errorf("balance_detail_id: contains illegal character '/'")
	}
	return nil
}

func (n BalanceDetailResourceName) ContainsWildcard() bool {
	return false || n.NetworkId == "-" || n.AddressId == "-" || n.BalanceId == "-" || n.BalanceDetailId == "-"
}

func (n BalanceDetailResourceName) String() string {
	return resourcename.Sprint(
		"networks/{network_id}/addresses/{address_id}/balances/{balance_id}/balanceDetails/{balance_detail_id}",
		n.NetworkId,
		n.AddressId,
		n.BalanceId,
		n.BalanceDetailId,
	)
}

func (n BalanceDetailResourceName) MarshalString() (string, error) {
	if err := n.Validate(); err != nil {
		return "", err
	}
	return n.String(), nil
}

func (n *BalanceDetailResourceName) UnmarshalString(name string) error {
	return resourcename.Sscan(
		name,
		"networks/{network_id}/addresses/{address_id}/balances/{balance_id}/balanceDetails/{balance_detail_id}",
		&n.NetworkId,
		&n.AddressId,
		&n.BalanceId,
		&n.BalanceDetailId,
	)
}

func (n BalanceDetailResourceName) AddressResourceName() AddressResourceName {
	return AddressResourceName{
		NetworkId: n.NetworkId,
		AddressId: n.AddressId,
	}
}

func (n BalanceDetailResourceName) BalanceResourceName() BalanceResourceName {
	return BalanceResourceName{
		NetworkId: n.NetworkId,
		AddressId: n.AddressId,
		BalanceId: n.BalanceId,
	}
}
