# Change Log

## [0.14.0](https://github.com/go-swagger/go-swagger/tree/0.14.0) (2018-05-25)
[Full Changelog](https://github.com/go-swagger/go-swagger/compare/0.13.0...0.14.0)

**Implemented enhancements:**

- Multipart with no file causes InternalServerError [\#1400](https://github.com/go-swagger/go-swagger/issues/1400)
- Generated configure file has confusing directions. [\#1384](https://github.com/go-swagger/go-swagger/issues/1384)
- Quiet mode and log redirection [\#1370](https://github.com/go-swagger/go-swagger/issues/1370)
- Custom templating: custom templates not associated with non-asset dependencies [\#1362](https://github.com/go-swagger/go-swagger/issues/1362)
- How to generate a correct struct file name from "\#/definitions/IPAM" [\#1344](https://github.com/go-swagger/go-swagger/issues/1344)
- Shutdown method on server do not close the server [\#1316](https://github.com/go-swagger/go-swagger/issues/1316)
- Enhancement: multiple instances of error messages for invalid spec [\#1307](https://github.com/go-swagger/go-swagger/issues/1307)
- Allow adding/overriding Consumers and Producers [\#1301](https://github.com/go-swagger/go-swagger/issues/1301)
- Invalid recursive type [\#1277](https://github.com/go-swagger/go-swagger/issues/1277)
- Examples are not validated [\#1231](https://github.com/go-swagger/go-swagger/issues/1231)
- Security definition order is not consistent between code generations [\#1214](https://github.com/go-swagger/go-swagger/issues/1214)
- Security only supports "OR" logic, not "AND" [\#1089](https://github.com/go-swagger/go-swagger/issues/1089)
- swagger validate: the need for better error messages [\#859](https://github.com/go-swagger/go-swagger/issues/859)
- max int64 and uint64 handling [\#581](https://github.com/go-swagger/go-swagger/issues/581)
- implement validation: unique scopes in security reference [\#14](https://github.com/go-swagger/go-swagger/issues/14)

**Fixed bugs:**

- No validation is called when the object referring to the array type parameter [\#1537](https://github.com/go-swagger/go-swagger/issues/1537)
- Body params that are Arrays of Objects generate un-compilable code due to Validate method [\#1536](https://github.com/go-swagger/go-swagger/issues/1536)
- Allof with a polymorphic type can have conflicting field names  [\#1532](https://github.com/go-swagger/go-swagger/issues/1532)
- Nested tuple is not validated [\#1487](https://github.com/go-swagger/go-swagger/issues/1487)
- Generated validation method miss some fields [\#1479](https://github.com/go-swagger/go-swagger/issues/1479)
- mixin removes securityDefinitions [\#1471](https://github.com/go-swagger/go-swagger/issues/1471)
- Invalid code generation with AdditionalProperties [\#1453](https://github.com/go-swagger/go-swagger/issues/1453)
- Simple aliased model type does not validate format [\#1437](https://github.com/go-swagger/go-swagger/issues/1437)
- Generator does not support polymorphic and addl props in the same type. [\#1409](https://github.com/go-swagger/go-swagger/issues/1409)
- responses with external $ref thrown nil pointer dereference [\#1406](https://github.com/go-swagger/go-swagger/issues/1406)
- Required properties are not validated when additionalProperties: true is provided [\#1397](https://github.com/go-swagger/go-swagger/issues/1397)
- No validation is called on body of array type parameter. [\#1392](https://github.com/go-swagger/go-swagger/issues/1392)
- server generation chokes on flattened definitions [\#1388](https://github.com/go-swagger/go-swagger/issues/1388)
- Default values for simple arrays generate code that does not compile [\#1378](https://github.com/go-swagger/go-swagger/issues/1378)
- Codegen fixture \[discriminators\] produces code that doesn't compile [\#1376](https://github.com/go-swagger/go-swagger/issues/1376)
- Generated server with form-data required=false evaluates file to nil [\#1373](https://github.com/go-swagger/go-swagger/issues/1373)
- --dump-data no longer working [\#1356](https://github.com/go-swagger/go-swagger/issues/1356)
- `--skip-validator` not work for `swagger generate model` [\#1354](https://github.com/go-swagger/go-swagger/issues/1354)
- \[feedback\] format mac does not work in swagger:strfmt [\#1348](https://github.com/go-swagger/go-swagger/issues/1348)
- Why not validate not required field even if it has format [\#1347](https://github.com/go-swagger/go-swagger/issues/1347)
- JSON marshaling and unmarshaling broken for object containing array of polymorphic types. [\#1336](https://github.com/go-swagger/go-swagger/issues/1336)
- Temporary files are not deleted on program termination [\#1331](https://github.com/go-swagger/go-swagger/issues/1331)
- Invalid receiver error for a response of type `file` [\#1327](https://github.com/go-swagger/go-swagger/issues/1327)
- ressource id type array leads to invalid generated code [\#1314](https://github.com/go-swagger/go-swagger/issues/1314)
- Generated client parameter does not set request body for arbitrary object. [\#1309](https://github.com/go-swagger/go-swagger/issues/1309)
- nested properties [\#1296](https://github.com/go-swagger/go-swagger/issues/1296)
- embedded spec discards information from original spec [\#1281](https://github.com/go-swagger/go-swagger/issues/1281)
- BodyParam of type array doesn't properly generate client code [\#1280](https://github.com/go-swagger/go-swagger/issues/1280)
- swagger flatten generates invalid spec [\#1270](https://github.com/go-swagger/go-swagger/issues/1270)
- Server generation: open 'xxx.json/yyy.json' no such file or directory \[cascading $ref\] [\#1259](https://github.com/go-swagger/go-swagger/issues/1259)
- Server generation: object has no key \[cascading $ref\] [\#1258](https://github.com/go-swagger/go-swagger/issues/1258)
- Type ref don't contain value check [\#1237](https://github.com/go-swagger/go-swagger/issues/1237)
- Examples are not validated [\#1231](https://github.com/go-swagger/go-swagger/issues/1231)
- Codegen generates invalid go code for `additionalProperties: true` [\#1198](https://github.com/go-swagger/go-swagger/issues/1198)
- Invalid server code generated for file response [\#1195](https://github.com/go-swagger/go-swagger/issues/1195)
- Adding length to a string with `uri` format will result i unworkable generated code [\#1191](https://github.com/go-swagger/go-swagger/issues/1191)
- Client requires non-required field for validation. [\#1187](https://github.com/go-swagger/go-swagger/issues/1187)
- Generated code does not handle 307 redirects properly [\#1170](https://github.com/go-swagger/go-swagger/issues/1170)
- Problem with datetime format [\#1084](https://github.com/go-swagger/go-swagger/issues/1084)
- Valid struct is not generated [\#1066](https://github.com/go-swagger/go-swagger/issues/1066)
- Client generation fails with `object has no key "UserBase"` [\#1065](https://github.com/go-swagger/go-swagger/issues/1065)
- Missing declarations and invalid code [\#1062](https://github.com/go-swagger/go-swagger/issues/1062)
- dot symbol in the path cause problems [\#1050](https://github.com/go-swagger/go-swagger/issues/1050)
- Missing fields in generated marshaler/unmarshaler when the object extends other objects [\#1042](https://github.com/go-swagger/go-swagger/issues/1042)
- referenced path item cause an error [\#1034](https://github.com/go-swagger/go-swagger/issues/1034)
- Response examples break definition references [\#1013](https://github.com/go-swagger/go-swagger/issues/1013)
- incorrect API response if using allof ref [\#979](https://github.com/go-swagger/go-swagger/issues/979)
- swagger GSMA [\#951](https://github.com/go-swagger/go-swagger/issues/951)
- Generated server marks all parameters in response as required [\#910](https://github.com/go-swagger/go-swagger/issues/910)
- UUIDs do not appear to be validated [\#909](https://github.com/go-swagger/go-swagger/issues/909)
- Resolver does not expand relative path references [\#890](https://github.com/go-swagger/go-swagger/issues/890)
- Generator don't generates validation for embended models [\#866](https://github.com/go-swagger/go-swagger/issues/866)
- Non-compiling generated code when parameter is array type with enum validation and underscore in name [\#863](https://github.com/go-swagger/go-swagger/issues/863)
- handler in todo-list tutorial doesn't match the example code [\#858](https://github.com/go-swagger/go-swagger/issues/858)
- Multiple validation errors results in only one validation being shown in response [\#667](https://github.com/go-swagger/go-swagger/issues/667)
- Broken model code generated for polymorphic swagger types that have lists of non-concrete types. [\#607](https://github.com/go-swagger/go-swagger/issues/607)
- Missing Validate method on polymorphic/discriminator types [\#606](https://github.com/go-swagger/go-swagger/issues/606)
- Code generation error for binary stream producer, consumer [\#533](https://github.com/go-swagger/go-swagger/issues/533)

**Closed issues:**

- `swagger validate` fails to complete when referencing another file [\#1535](https://github.com/go-swagger/go-swagger/issues/1535)
- Go vendors dependencies: Cannot use a generated client in a server [\#1534](https://github.com/go-swagger/go-swagger/issues/1534)
- Embedded spec is not flattened and won't work if there are external references. [\#1528](https://github.com/go-swagger/go-swagger/issues/1528)
- How to print the error message in response sample using "swagger:response" tag [\#1526](https://github.com/go-swagger/go-swagger/issues/1526)
- Response schema of type array being aliased [\#1524](https://github.com/go-swagger/go-swagger/issues/1524)
- Validating a Standard spec [\#1522](https://github.com/go-swagger/go-swagger/issues/1522)
- Client parameters don't set body when model is an enum [\#1513](https://github.com/go-swagger/go-swagger/issues/1513)
- Spec generation doesn't honour the ",string" JSON struct tag [\#1510](https://github.com/go-swagger/go-swagger/issues/1510)
- How to add static sections? [\#1509](https://github.com/go-swagger/go-swagger/issues/1509)
- Type mismatch in flatten source [\#1504](https://github.com/go-swagger/go-swagger/issues/1504)
- Not possible to hide individual struct fields [\#1497](https://github.com/go-swagger/go-swagger/issues/1497)
- strfmt.Datetime how to omit when empty, nil or time.Time{} [\#1491](https://github.com/go-swagger/go-swagger/issues/1491)
- Breaking change in Authenticator runtime [\#1488](https://github.com/go-swagger/go-swagger/issues/1488)
- Request model is not loading in swagger  [\#1476](https://github.com/go-swagger/go-swagger/issues/1476)
- Unable to generate Swagger spec [\#1475](https://github.com/go-swagger/go-swagger/issues/1475)
- Passing empty slice as parameter results in panic [\#1462](https://github.com/go-swagger/go-swagger/issues/1462)
- malloc deadlock [\#1454](https://github.com/go-swagger/go-swagger/issues/1454)
- Support for optional auth? [\#1446](https://github.com/go-swagger/go-swagger/issues/1446)
- Optional SSN field performs no validation [\#1434](https://github.com/go-swagger/go-swagger/issues/1434)
- Possible to have models in Subdirectory? [\#1428](https://github.com/go-swagger/go-swagger/issues/1428)
- Do we have to specifically allow HEAD requests? [\#1426](https://github.com/go-swagger/go-swagger/issues/1426)
- How to pass TLS structure from net.HttpRequest into my handler? [\#1423](https://github.com/go-swagger/go-swagger/issues/1423)
- Undefined variable "filterI" presents after code  generation when using nested "collectionFormat": "csv" [\#1414](https://github.com/go-swagger/go-swagger/issues/1414)
- New feature to allow Parameters section [\#1404](https://github.com/go-swagger/go-swagger/issues/1404)
- flatten command remove the empty security properties [\#1396](https://github.com/go-swagger/go-swagger/issues/1396)
- Getting duplicate Definitions under 0.13  [\#1385](https://github.com/go-swagger/go-swagger/issues/1385)
- Add Title generation for info part of spec. [\#1382](https://github.com/go-swagger/go-swagger/issues/1382)
- package and file name contain underscore \(after a change in go-swagger\) [\#1380](https://github.com/go-swagger/go-swagger/issues/1380)
- match for the market the limit of the new system with esi [\#1374](https://github.com/go-swagger/go-swagger/issues/1374)
- Standard library packages not found [\#1359](https://github.com/go-swagger/go-swagger/issues/1359)
- Why is vendor folder still version controlled? [\#1352](https://github.com/go-swagger/go-swagger/issues/1352)
- Newbie needs help with wiring server-side handlers [\#1351](https://github.com/go-swagger/go-swagger/issues/1351)
- The generate server command sorts the Operations but not the Models. [\#1349](https://github.com/go-swagger/go-swagger/issues/1349)
- Compilation failure from pestore example [\#1346](https://github.com/go-swagger/go-swagger/issues/1346)
- Improper UnmarshalJSON of polymorphic object contained in another object [\#1341](https://github.com/go-swagger/go-swagger/issues/1341)
- Generated client ignores application/x-www-form-urlencoded and uses multipart. [\#1332](https://github.com/go-swagger/go-swagger/issues/1332)
- can't compile generated server code for "file" in requests [\#1330](https://github.com/go-swagger/go-swagger/issues/1330)
- Improper import for a models directory placed in a subdirectory [\#1326](https://github.com/go-swagger/go-swagger/issues/1326)
- Make generated client take an `io.Reader` for parameters of type `file` [\#1325](https://github.com/go-swagger/go-swagger/issues/1325)
- Additional struct inserted when using allOf and an inline definition compared to 0.9.0 [\#1323](https://github.com/go-swagger/go-swagger/issues/1323)
- External References Aren't Expanded for Models [\#1322](https://github.com/go-swagger/go-swagger/issues/1322)
- How to define multiple content-type for one API [\#1319](https://github.com/go-swagger/go-swagger/issues/1319)
- Using go-swagger to generate other artifacts using custom templates not working from 0.12.0 [\#1312](https://github.com/go-swagger/go-swagger/issues/1312)
- unit test output is too verbose [\#1299](https://github.com/go-swagger/go-swagger/issues/1299)
- Master broken g8f4ad4c [\#1293](https://github.com/go-swagger/go-swagger/issues/1293)
- Issue with folded paths [\#1292](https://github.com/go-swagger/go-swagger/issues/1292)
- server generate : can't run custom template in operationGroups [\#1290](https://github.com/go-swagger/go-swagger/issues/1290)
- .security in body must be of type array: "null" [\#1286](https://github.com/go-swagger/go-swagger/issues/1286)
- Stream server problem [\#1278](https://github.com/go-swagger/go-swagger/issues/1278)
- custom templating: need the target path as base import [\#1274](https://github.com/go-swagger/go-swagger/issues/1274)
- improve error handling in generator [\#1272](https://github.com/go-swagger/go-swagger/issues/1272)
- Feature Request: Renaming interface method from handle to actual method name [\#1271](https://github.com/go-swagger/go-swagger/issues/1271)
- generate client errors out because of a nullable field in a definition [\#1265](https://github.com/go-swagger/go-swagger/issues/1265)
- Command line option to specify copyright does not work in long mode [\#1263](https://github.com/go-swagger/go-swagger/issues/1263)
- Code generation fails when swagger description property includes text "\*/" [\#1254](https://github.com/go-swagger/go-swagger/issues/1254)
- Changing SwaggerUI [\#1250](https://github.com/go-swagger/go-swagger/issues/1250)
- Codegen gives SIGSEGV [\#1238](https://github.com/go-swagger/go-swagger/issues/1238)
- Go-swagger v0.12.0 - invalid memory address or nil pointer dereference [\#1171](https://github.com/go-swagger/go-swagger/issues/1171)
- Generating spec pulls in unused enumeration types from Protobuf-generated files [\#1149](https://github.com/go-swagger/go-swagger/issues/1149)
- How the Response Sample was Executeing? [\#1144](https://github.com/go-swagger/go-swagger/issues/1144)
- migrate to use net.Context [\#96](https://github.com/go-swagger/go-swagger/issues/96)

**Merged pull requests:**

- Update vendor - 2018-05-24 [\#1547](https://github.com/go-swagger/go-swagger/pull/1547) ([fredbi](https://github.com/fredbi))
- Allow white space sensitive markdown in comments. [\#1541](https://github.com/go-swagger/go-swagger/pull/1541) ([dougnd](https://github.com/dougnd))
- Polymorphic unmarshaller [\#1540](https://github.com/go-swagger/go-swagger/pull/1540) ([fredbi](https://github.com/fredbi))
- Body validations [\#1539](https://github.com/go-swagger/go-swagger/pull/1539) ([fredbi](https://github.com/fredbi))
- Ordering security definitions and requirements [\#1533](https://github.com/go-swagger/go-swagger/pull/1533) ([fredbi](https://github.com/fredbi))
- Update custom-server.md [\#1531](https://github.com/go-swagger/go-swagger/pull/1531) ([arunvm123](https://github.com/arunvm123))
- revamp README [\#1529](https://github.com/go-swagger/go-swagger/pull/1529) ([fredbi](https://github.com/fredbi))
- Allow struct fields to be annotated with swagger:ignore [\#1527](https://github.com/go-swagger/go-swagger/pull/1527) ([neilgarb](https://github.com/neilgarb))
- Fix complex anonymous additional properties [\#1521](https://github.com/go-swagger/go-swagger/pull/1521) ([fredbi](https://github.com/fredbi))
- Fix build deps [\#1515](https://github.com/go-swagger/go-swagger/pull/1515) ([casualjim](https://github.com/casualjim))
- fix writing enum parameters \(\#1513\) [\#1514](https://github.com/go-swagger/go-swagger/pull/1514) ([stevecookform3](https://github.com/stevecookform3))
- Honour JSON ",string" directive when generating spec [\#1511](https://github.com/go-swagger/go-swagger/pull/1511) ([neilgarb](https://github.com/neilgarb))
- Generated client parameter does not set request body for map types [\#1508](https://github.com/go-swagger/go-swagger/pull/1508) ([koron](https://github.com/koron))
- Lifts validations [\#1507](https://github.com/go-swagger/go-swagger/pull/1507) ([fredbi](https://github.com/fredbi))
- missing letter in message \(possiby =\> possibly\) [\#1500](https://github.com/go-swagger/go-swagger/pull/1500) ([tmatias](https://github.com/tmatias))
- support --skip-flatten for model generation [\#1498](https://github.com/go-swagger/go-swagger/pull/1498) ([zhuangqh](https://github.com/zhuangqh))
- Fix typos in docs/use/middleware.html [\#1492](https://github.com/go-swagger/go-swagger/pull/1492) ([davidmi](https://github.com/davidmi))
- Extend gen operation group [\#1482](https://github.com/go-swagger/go-swagger/pull/1482) ([fredbi](https://github.com/fredbi))
- Composed auth example [\#1481](https://github.com/go-swagger/go-swagger/pull/1481) ([fredbi](https://github.com/fredbi))
- Allow AND and Optional auth expressions [\#1478](https://github.com/go-swagger/go-swagger/pull/1478) ([casualjim](https://github.com/casualjim))
- server: generic interface body is never filled [\#1474](https://github.com/go-swagger/go-swagger/pull/1474) ([koron](https://github.com/koron))
- Fix panic on empty slice PathParam [\#1463](https://github.com/go-swagger/go-swagger/pull/1463) ([marclop](https://github.com/marclop))
- FAQ update [\#1460](https://github.com/go-swagger/go-swagger/pull/1460) ([fredbi](https://github.com/fredbi))
- \* Fix model build issue with AdditionalItems \(serialization, validation\) [\#1455](https://github.com/go-swagger/go-swagger/pull/1455) ([fredbi](https://github.com/fredbi))
- Acknowledge bug fixes and add CI fixtures. [\#1452](https://github.com/go-swagger/go-swagger/pull/1452) ([fredbi](https://github.com/fredbi))
- Vendor update as of 2018-03-09 [\#1451](https://github.com/go-swagger/go-swagger/pull/1451) ([fredbi](https://github.com/fredbi))
- Failure to parse multiform data results in HTTP 400 status [\#1449](https://github.com/go-swagger/go-swagger/pull/1449) ([fredbi](https://github.com/fredbi))
- Fixes \#910 [\#1448](https://github.com/go-swagger/go-swagger/pull/1448) ([fredbi](https://github.com/fredbi))
- Acknowledge corrected issues with test cases [\#1447](https://github.com/go-swagger/go-swagger/pull/1447) ([fredbi](https://github.com/fredbi))
- Small refactoring of schemavalidator.gotmpl [\#1445](https://github.com/go-swagger/go-swagger/pull/1445) ([fredbi](https://github.com/fredbi))
- Enable validation for inline body parameters [\#1444](https://github.com/go-swagger/go-swagger/pull/1444) ([fredbi](https://github.com/fredbi))
- Fixing \#1437 uncovered another issue on type aliasing. [\#1443](https://github.com/go-swagger/go-swagger/pull/1443) ([fredbi](https://github.com/fredbi))
- Add --skip-validation option to generate model command [\#1442](https://github.com/go-swagger/go-swagger/pull/1442) ([fredbi](https://github.com/fredbi))
- Added codegen fixtures to acknowledge fixed issues. [\#1441](https://github.com/go-swagger/go-swagger/pull/1441) ([fredbi](https://github.com/fredbi))
- Small refactoring on custom extensions usage [\#1440](https://github.com/go-swagger/go-swagger/pull/1440) ([fredbi](https://github.com/fredbi))
- Fixes \#1437 \[format validation in simple schemas\] [\#1438](https://github.com/go-swagger/go-swagger/pull/1438) ([fredbi](https://github.com/fredbi))
- Document how to avoid "target must reside inside a location in the $GOPATH/src" using docker [\#1435](https://github.com/go-swagger/go-swagger/pull/1435) ([tschaub](https://github.com/tschaub))
- Vendor update [\#1424](https://github.com/go-swagger/go-swagger/pull/1424) ([fredbi](https://github.com/fredbi))
- Sort AllOf schemas for generation [\#1422](https://github.com/go-swagger/go-swagger/pull/1422) ([fredbi](https://github.com/fredbi))
- Added test case from issue\#1414 as fixture [\#1421](https://github.com/go-swagger/go-swagger/pull/1421) ([fredbi](https://github.com/fredbi))
- Fixes issue \#1084 [\#1420](https://github.com/go-swagger/go-swagger/pull/1420) ([fredbi](https://github.com/fredbi))
- Add test for \#1198 which was fixed with \#1397 [\#1411](https://github.com/go-swagger/go-swagger/pull/1411) ([gregmarr](https://github.com/gregmarr))
- Support both discriminated and addl props in one type \#1409 [\#1410](https://github.com/go-swagger/go-swagger/pull/1410) ([gregmarr](https://github.com/gregmarr))
- docs: replace `httpkit` with `runtime` [\#1407](https://github.com/go-swagger/go-swagger/pull/1407) ([darkowlzz](https://github.com/darkowlzz))
- Added Parameters section to swagger:route [\#1405](https://github.com/go-swagger/go-swagger/pull/1405) ([jucardi](https://github.com/jucardi))
- Properties not validated w/additionalProperties \#1397 [\#1403](https://github.com/go-swagger/go-swagger/pull/1403) ([gregmarr](https://github.com/gregmarr))
- fixes writing client stream body [\#1399](https://github.com/go-swagger/go-swagger/pull/1399) ([casualjim](https://github.com/casualjim))
- Fix issues on simple params [\#1394](https://github.com/go-swagger/go-swagger/pull/1394) ([fredbi](https://github.com/fredbi))
- Support checking presence of path, header, and body parameters [\#1390](https://github.com/go-swagger/go-swagger/pull/1390) ([ZachEddy](https://github.com/ZachEddy))
- Make generate server sort the models \#1349 [\#1387](https://github.com/go-swagger/go-swagger/pull/1387) ([gregmarr](https://github.com/gregmarr))
- Add quiet mode and output redirection [\#1371](https://github.com/go-swagger/go-swagger/pull/1371) ([fredbi](https://github.com/fredbi))
- 1348 Add generation of validate on MAC format [\#1369](https://github.com/go-swagger/go-swagger/pull/1369) ([fredbi](https://github.com/fredbi))
- Add format validation on non required schema properties [\#1367](https://github.com/go-swagger/go-swagger/pull/1367) ([fredbi](https://github.com/fredbi))
- Fixed dump-data as json [\#1366](https://github.com/go-swagger/go-swagger/pull/1366) ([fredbi](https://github.com/fredbi))
- Added dependency resolution with repository on custom templates \(not … [\#1365](https://github.com/go-swagger/go-swagger/pull/1365) ([fredbi](https://github.com/fredbi))
- Adding fix for issue \#1341 [\#1364](https://github.com/go-swagger/go-swagger/pull/1364) ([nickrmc83](https://github.com/nickrmc83))
- Edit the todo tutorial for grammar and clarity [\#1363](https://github.com/go-swagger/go-swagger/pull/1363) ([autarch](https://github.com/autarch))
- Added a flag to add more intialisms [\#1353](https://github.com/go-swagger/go-swagger/pull/1353) ([diego-fu-hs](https://github.com/diego-fu-hs))
- case sensitive import path on Windows [\#1345](https://github.com/go-swagger/go-swagger/pull/1345) ([koron](https://github.com/koron))
- Fix doc links [\#1343](https://github.com/go-swagger/go-swagger/pull/1343) ([fredbi](https://github.com/fredbi))
- Integration PR from validate: go-openapi/validate\#42 \(issue go-openapi/validate\#44\) [\#1340](https://github.com/go-swagger/go-swagger/pull/1340) ([casualjim](https://github.com/casualjim))
- 1331 - Delete temporary files [\#1333](https://github.com/go-swagger/go-swagger/pull/1333) ([sebastien-rosset](https://github.com/sebastien-rosset))
- support file as response schema [\#1329](https://github.com/go-swagger/go-swagger/pull/1329) ([casualjim](https://github.com/casualjim))
- update vendor [\#1324](https://github.com/go-swagger/go-swagger/pull/1324) ([kreamyx](https://github.com/kreamyx))
- Add shutdown handling of graceful server on calls to Server.Shutdown [\#1320](https://github.com/go-swagger/go-swagger/pull/1320) ([Crevil](https://github.com/Crevil))
- Removed check of array type of body when writing to request [\#1318](https://github.com/go-swagger/go-swagger/pull/1318) ([geret13](https://github.com/geret13))
- fix a typo in template [\#1317](https://github.com/go-swagger/go-swagger/pull/1317) ([koron](https://github.com/koron))
- move language specific baseImport check to LanguageOpts \#1312 [\#1315](https://github.com/go-swagger/go-swagger/pull/1315) ([elakito](https://github.com/elakito))
- client request parameter will set body param for array of interface{} [\#1313](https://github.com/go-swagger/go-swagger/pull/1313) ([e-zhang](https://github.com/e-zhang))
- check for interface body param in client parameter WriteToRequest [\#1310](https://github.com/go-swagger/go-swagger/pull/1310) ([e-zhang](https://github.com/e-zhang))
- 342 fix add fixture [\#1306](https://github.com/go-swagger/go-swagger/pull/1306) ([fredbi](https://github.com/fredbi))
- 1171. Add fixture [\#1305](https://github.com/go-swagger/go-swagger/pull/1305) ([fredbi](https://github.com/fredbi))
- 1238-fix: add fixture in UT  [\#1304](https://github.com/go-swagger/go-swagger/pull/1304) ([fredbi](https://github.com/fredbi))
- Enriched UT on template\_repo.go [\#1303](https://github.com/go-swagger/go-swagger/pull/1303) ([fredbi](https://github.com/fredbi))
- Allow adding or overriding consumers and producers [\#1302](https://github.com/go-swagger/go-swagger/pull/1302) ([dmjones500](https://github.com/dmjones500))
- 1299-fix-unit-test-verbosity [\#1300](https://github.com/go-swagger/go-swagger/pull/1300) ([fredbi](https://github.com/fredbi))
- 1290-fix server generation now supports operationGroups templates jus… [\#1298](https://github.com/go-swagger/go-swagger/pull/1298) ([fredbi](https://github.com/fredbi))
- Bump go-openapi/spec [\#1287](https://github.com/go-swagger/go-swagger/pull/1287) ([databus23](https://github.com/databus23))
- Ref resolution changes in the swagger binary side [\#1285](https://github.com/go-swagger/go-swagger/pull/1285) ([kreamyx](https://github.com/kreamyx))
- bump go-openapi/spec [\#1282](https://github.com/go-swagger/go-swagger/pull/1282) ([databus23](https://github.com/databus23))
- Fix \#1274 - add a new template variable in GenCommon. [\#1275](https://github.com/go-swagger/go-swagger/pull/1275) ([fredbi](https://github.com/fredbi))
- fix \#1272 - Improve error handling in generator [\#1273](https://github.com/go-swagger/go-swagger/pull/1273) ([fredbi](https://github.com/fredbi))

\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*
