// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SetTeamRolesReader is a Reader for the SetTeamRoles structure.
type SetTeamRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SetTeamRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSetTeamRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSetTeamRolesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSetTeamRolesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewSetTeamRolesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSetTeamRolesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /access-control/teams/{teamId}/roles] setTeamRoles", response, response.Code())
	}
}

// NewSetTeamRolesOK creates a SetTeamRolesOK with default headers values
func NewSetTeamRolesOK() *SetTeamRolesOK {
	return &SetTeamRolesOK{}
}

/*
SetTeamRolesOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type SetTeamRolesOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this set team roles Ok response has a 2xx status code
func (o *SetTeamRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this set team roles Ok response has a 3xx status code
func (o *SetTeamRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set team roles Ok response has a 4xx status code
func (o *SetTeamRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this set team roles Ok response has a 5xx status code
func (o *SetTeamRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this set team roles Ok response a status code equal to that given
func (o *SetTeamRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the set team roles Ok response
func (o *SetTeamRolesOK) Code() int {
	return 200
}

func (o *SetTeamRolesOK) Error() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesOk  %+v", 200, o.Payload)
}

func (o *SetTeamRolesOK) String() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesOk  %+v", 200, o.Payload)
}

func (o *SetTeamRolesOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *SetTeamRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetTeamRolesBadRequest creates a SetTeamRolesBadRequest with default headers values
func NewSetTeamRolesBadRequest() *SetTeamRolesBadRequest {
	return &SetTeamRolesBadRequest{}
}

/*
SetTeamRolesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type SetTeamRolesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set team roles bad request response has a 2xx status code
func (o *SetTeamRolesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set team roles bad request response has a 3xx status code
func (o *SetTeamRolesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set team roles bad request response has a 4xx status code
func (o *SetTeamRolesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this set team roles bad request response has a 5xx status code
func (o *SetTeamRolesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this set team roles bad request response a status code equal to that given
func (o *SetTeamRolesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the set team roles bad request response
func (o *SetTeamRolesBadRequest) Code() int {
	return 400
}

func (o *SetTeamRolesBadRequest) Error() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesBadRequest  %+v", 400, o.Payload)
}

func (o *SetTeamRolesBadRequest) String() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesBadRequest  %+v", 400, o.Payload)
}

func (o *SetTeamRolesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetTeamRolesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetTeamRolesForbidden creates a SetTeamRolesForbidden with default headers values
func NewSetTeamRolesForbidden() *SetTeamRolesForbidden {
	return &SetTeamRolesForbidden{}
}

/*
SetTeamRolesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type SetTeamRolesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set team roles forbidden response has a 2xx status code
func (o *SetTeamRolesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set team roles forbidden response has a 3xx status code
func (o *SetTeamRolesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set team roles forbidden response has a 4xx status code
func (o *SetTeamRolesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this set team roles forbidden response has a 5xx status code
func (o *SetTeamRolesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this set team roles forbidden response a status code equal to that given
func (o *SetTeamRolesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the set team roles forbidden response
func (o *SetTeamRolesForbidden) Code() int {
	return 403
}

func (o *SetTeamRolesForbidden) Error() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesForbidden  %+v", 403, o.Payload)
}

func (o *SetTeamRolesForbidden) String() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesForbidden  %+v", 403, o.Payload)
}

func (o *SetTeamRolesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetTeamRolesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetTeamRolesNotFound creates a SetTeamRolesNotFound with default headers values
func NewSetTeamRolesNotFound() *SetTeamRolesNotFound {
	return &SetTeamRolesNotFound{}
}

/*
SetTeamRolesNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type SetTeamRolesNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set team roles not found response has a 2xx status code
func (o *SetTeamRolesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set team roles not found response has a 3xx status code
func (o *SetTeamRolesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set team roles not found response has a 4xx status code
func (o *SetTeamRolesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this set team roles not found response has a 5xx status code
func (o *SetTeamRolesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this set team roles not found response a status code equal to that given
func (o *SetTeamRolesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the set team roles not found response
func (o *SetTeamRolesNotFound) Code() int {
	return 404
}

func (o *SetTeamRolesNotFound) Error() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesNotFound  %+v", 404, o.Payload)
}

func (o *SetTeamRolesNotFound) String() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesNotFound  %+v", 404, o.Payload)
}

func (o *SetTeamRolesNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetTeamRolesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetTeamRolesInternalServerError creates a SetTeamRolesInternalServerError with default headers values
func NewSetTeamRolesInternalServerError() *SetTeamRolesInternalServerError {
	return &SetTeamRolesInternalServerError{}
}

/*
SetTeamRolesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SetTeamRolesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this set team roles internal server error response has a 2xx status code
func (o *SetTeamRolesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set team roles internal server error response has a 3xx status code
func (o *SetTeamRolesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set team roles internal server error response has a 4xx status code
func (o *SetTeamRolesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this set team roles internal server error response has a 5xx status code
func (o *SetTeamRolesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this set team roles internal server error response a status code equal to that given
func (o *SetTeamRolesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the set team roles internal server error response
func (o *SetTeamRolesInternalServerError) Code() int {
	return 500
}

func (o *SetTeamRolesInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesInternalServerError  %+v", 500, o.Payload)
}

func (o *SetTeamRolesInternalServerError) String() string {
	return fmt.Sprintf("[PUT /access-control/teams/{teamId}/roles][%d] setTeamRolesInternalServerError  %+v", 500, o.Payload)
}

func (o *SetTeamRolesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SetTeamRolesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
