// Code generated by go-swagger; DO NOT EDIT.

package folders

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteFolderReader is a Reader for the DeleteFolder structure.
type DeleteFolderReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteFolderReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteFolderOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteFolderBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeleteFolderUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteFolderForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteFolderNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteFolderInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /folders/{folder_uid}] deleteFolder", response, response.Code())
	}
}

// NewDeleteFolderOK creates a DeleteFolderOK with default headers values
func NewDeleteFolderOK() *DeleteFolderOK {
	return &DeleteFolderOK{}
}

/*
DeleteFolderOK describes a response with status code 200, with default header values.

(empty)
*/
type DeleteFolderOK struct {
	Payload *models.DeleteFolderOKBody
}

// IsSuccess returns true when this delete folder Ok response has a 2xx status code
func (o *DeleteFolderOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete folder Ok response has a 3xx status code
func (o *DeleteFolderOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete folder Ok response has a 4xx status code
func (o *DeleteFolderOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete folder Ok response has a 5xx status code
func (o *DeleteFolderOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete folder Ok response a status code equal to that given
func (o *DeleteFolderOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete folder Ok response
func (o *DeleteFolderOK) Code() int {
	return 200
}

func (o *DeleteFolderOK) Error() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderOk  %+v", 200, o.Payload)
}

func (o *DeleteFolderOK) String() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderOk  %+v", 200, o.Payload)
}

func (o *DeleteFolderOK) GetPayload() *models.DeleteFolderOKBody {
	return o.Payload
}

func (o *DeleteFolderOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DeleteFolderOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteFolderBadRequest creates a DeleteFolderBadRequest with default headers values
func NewDeleteFolderBadRequest() *DeleteFolderBadRequest {
	return &DeleteFolderBadRequest{}
}

/*
DeleteFolderBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type DeleteFolderBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete folder bad request response has a 2xx status code
func (o *DeleteFolderBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete folder bad request response has a 3xx status code
func (o *DeleteFolderBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete folder bad request response has a 4xx status code
func (o *DeleteFolderBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete folder bad request response has a 5xx status code
func (o *DeleteFolderBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete folder bad request response a status code equal to that given
func (o *DeleteFolderBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete folder bad request response
func (o *DeleteFolderBadRequest) Code() int {
	return 400
}

func (o *DeleteFolderBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteFolderBadRequest) String() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderBadRequest  %+v", 400, o.Payload)
}

func (o *DeleteFolderBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteFolderBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteFolderUnauthorized creates a DeleteFolderUnauthorized with default headers values
func NewDeleteFolderUnauthorized() *DeleteFolderUnauthorized {
	return &DeleteFolderUnauthorized{}
}

/*
DeleteFolderUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteFolderUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete folder unauthorized response has a 2xx status code
func (o *DeleteFolderUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete folder unauthorized response has a 3xx status code
func (o *DeleteFolderUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete folder unauthorized response has a 4xx status code
func (o *DeleteFolderUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete folder unauthorized response has a 5xx status code
func (o *DeleteFolderUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete folder unauthorized response a status code equal to that given
func (o *DeleteFolderUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete folder unauthorized response
func (o *DeleteFolderUnauthorized) Code() int {
	return 401
}

func (o *DeleteFolderUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderUnauthorized  %+v", 401, o.Payload)
}

func (o *DeleteFolderUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderUnauthorized  %+v", 401, o.Payload)
}

func (o *DeleteFolderUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteFolderUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteFolderForbidden creates a DeleteFolderForbidden with default headers values
func NewDeleteFolderForbidden() *DeleteFolderForbidden {
	return &DeleteFolderForbidden{}
}

/*
DeleteFolderForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteFolderForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete folder forbidden response has a 2xx status code
func (o *DeleteFolderForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete folder forbidden response has a 3xx status code
func (o *DeleteFolderForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete folder forbidden response has a 4xx status code
func (o *DeleteFolderForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete folder forbidden response has a 5xx status code
func (o *DeleteFolderForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete folder forbidden response a status code equal to that given
func (o *DeleteFolderForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete folder forbidden response
func (o *DeleteFolderForbidden) Code() int {
	return 403
}

func (o *DeleteFolderForbidden) Error() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderForbidden  %+v", 403, o.Payload)
}

func (o *DeleteFolderForbidden) String() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderForbidden  %+v", 403, o.Payload)
}

func (o *DeleteFolderForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteFolderForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteFolderNotFound creates a DeleteFolderNotFound with default headers values
func NewDeleteFolderNotFound() *DeleteFolderNotFound {
	return &DeleteFolderNotFound{}
}

/*
DeleteFolderNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeleteFolderNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete folder not found response has a 2xx status code
func (o *DeleteFolderNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete folder not found response has a 3xx status code
func (o *DeleteFolderNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete folder not found response has a 4xx status code
func (o *DeleteFolderNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete folder not found response has a 5xx status code
func (o *DeleteFolderNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete folder not found response a status code equal to that given
func (o *DeleteFolderNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete folder not found response
func (o *DeleteFolderNotFound) Code() int {
	return 404
}

func (o *DeleteFolderNotFound) Error() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderNotFound  %+v", 404, o.Payload)
}

func (o *DeleteFolderNotFound) String() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderNotFound  %+v", 404, o.Payload)
}

func (o *DeleteFolderNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteFolderNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteFolderInternalServerError creates a DeleteFolderInternalServerError with default headers values
func NewDeleteFolderInternalServerError() *DeleteFolderInternalServerError {
	return &DeleteFolderInternalServerError{}
}

/*
DeleteFolderInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteFolderInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete folder internal server error response has a 2xx status code
func (o *DeleteFolderInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete folder internal server error response has a 3xx status code
func (o *DeleteFolderInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete folder internal server error response has a 4xx status code
func (o *DeleteFolderInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete folder internal server error response has a 5xx status code
func (o *DeleteFolderInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete folder internal server error response a status code equal to that given
func (o *DeleteFolderInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete folder internal server error response
func (o *DeleteFolderInternalServerError) Code() int {
	return 500
}

func (o *DeleteFolderInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteFolderInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /folders/{folder_uid}][%d] deleteFolderInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteFolderInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteFolderInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
