// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPutAlertRuleGroupParams creates a new PutAlertRuleGroupParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPutAlertRuleGroupParams() *PutAlertRuleGroupParams {
	return &PutAlertRuleGroupParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPutAlertRuleGroupParamsWithTimeout creates a new PutAlertRuleGroupParams object
// with the ability to set a timeout on a request.
func NewPutAlertRuleGroupParamsWithTimeout(timeout time.Duration) *PutAlertRuleGroupParams {
	return &PutAlertRuleGroupParams{
		timeout: timeout,
	}
}

// NewPutAlertRuleGroupParamsWithContext creates a new PutAlertRuleGroupParams object
// with the ability to set a context for a request.
func NewPutAlertRuleGroupParamsWithContext(ctx context.Context) *PutAlertRuleGroupParams {
	return &PutAlertRuleGroupParams{
		Context: ctx,
	}
}

// NewPutAlertRuleGroupParamsWithHTTPClient creates a new PutAlertRuleGroupParams object
// with the ability to set a custom HTTPClient for a request.
func NewPutAlertRuleGroupParamsWithHTTPClient(client *http.Client) *PutAlertRuleGroupParams {
	return &PutAlertRuleGroupParams{
		HTTPClient: client,
	}
}

/*
PutAlertRuleGroupParams contains all the parameters to send to the API endpoint

	for the put alert rule group operation.

	Typically these are written to a http.Request.
*/
type PutAlertRuleGroupParams struct {

	// Body.
	Body *models.AlertRuleGroup

	// FolderUID.
	FolderUID string

	// Group.
	Group string

	// XDisableProvenance.
	XDisableProvenance *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the put alert rule group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutAlertRuleGroupParams) WithDefaults() *PutAlertRuleGroupParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the put alert rule group params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutAlertRuleGroupParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the put alert rule group params
func (o *PutAlertRuleGroupParams) WithTimeout(timeout time.Duration) *PutAlertRuleGroupParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put alert rule group params
func (o *PutAlertRuleGroupParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put alert rule group params
func (o *PutAlertRuleGroupParams) WithContext(ctx context.Context) *PutAlertRuleGroupParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put alert rule group params
func (o *PutAlertRuleGroupParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put alert rule group params
func (o *PutAlertRuleGroupParams) WithHTTPClient(client *http.Client) *PutAlertRuleGroupParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put alert rule group params
func (o *PutAlertRuleGroupParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the put alert rule group params
func (o *PutAlertRuleGroupParams) WithBody(body *models.AlertRuleGroup) *PutAlertRuleGroupParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the put alert rule group params
func (o *PutAlertRuleGroupParams) SetBody(body *models.AlertRuleGroup) {
	o.Body = body
}

// WithFolderUID adds the folderUID to the put alert rule group params
func (o *PutAlertRuleGroupParams) WithFolderUID(folderUID string) *PutAlertRuleGroupParams {
	o.SetFolderUID(folderUID)
	return o
}

// SetFolderUID adds the folderUid to the put alert rule group params
func (o *PutAlertRuleGroupParams) SetFolderUID(folderUID string) {
	o.FolderUID = folderUID
}

// WithGroup adds the group to the put alert rule group params
func (o *PutAlertRuleGroupParams) WithGroup(group string) *PutAlertRuleGroupParams {
	o.SetGroup(group)
	return o
}

// SetGroup adds the group to the put alert rule group params
func (o *PutAlertRuleGroupParams) SetGroup(group string) {
	o.Group = group
}

// WithXDisableProvenance adds the xDisableProvenance to the put alert rule group params
func (o *PutAlertRuleGroupParams) WithXDisableProvenance(xDisableProvenance *string) *PutAlertRuleGroupParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the put alert rule group params
func (o *PutAlertRuleGroupParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WriteToRequest writes these params to a swagger request
func (o *PutAlertRuleGroupParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param FolderUID
	if err := r.SetPathParam("FolderUID", o.FolderUID); err != nil {
		return err
	}

	// path param Group
	if err := r.SetPathParam("Group", o.Group); err != nil {
		return err
	}

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
