---
title: V1.3
weight: 90
---

# Version 1.3 release notes

The Tempo team is excited to announce the release of Tempo 1.3.

## Features and enhancements

- **Search** In addition to the existing search of recent traces,
support has been added to search traces in the backend store.
Refer to [Tempo search]({{< relref "../getting-started/tempo-in-grafana/#tempo-search" >}})
for details.

- **Improve ring functionality** The compactor ring automatically forgets about unhealthy ring members.

- **Protect instances from very large traces** The ingester keeps track of
traces that exceed the configured maximum size,
extending protection from very large traces to after the traces are flushed
to disk.

- **Expose additional metrics** These new metrics  are exposed:
    - `tempo_limits_overrides`
    - `tempo_limits_defaults`
    - `tempo_ingester_live_traces`
    - `tempodb_compaction_outstanding_blocks`

- **Azure credentials may be set in the environment** Instead of setting values
in the configuration,
environment variables may specify `AZURE_STORAGE_ACCOUNT` and `AZURE_STORAGE_KEY`.

## Upgrade considerations

When upgrading to Tempo v1.3, be aware of these breaking changes:

- [PR 1142](https://github.com/grafana/tempo/pull/1142): The OpenTelemetry Collector's GRPC receiver's default port changed from 55680 to 4317.

- [PR 1174](https://github.com/grafana/tempo/pull/1174): Configuration option
`querier.search_max_result_limit` is renamed to `query_frontend.search.max_result_limit`.
Configuration option `querier.search_default_result_limit` is renamed to `query_frontend.search.default_result_limit`.

- [PR 1173](https://github.com/grafana/tempo/pull/1173): Removed the
deprecated `Push` method from `tempopb.Pusher`.

## Known issues

- Grafana does not yet support the `tempoBackendSearch` feature toggle
to enable searches in the backend datastore.

## Bug fixes

### 1.3.1 bug fixes

- [PR 1260](https://github.com/grafana/tempo/pull/1260) **mapno**: Fixed a panic that occurred when using etcd as the ring's backend storage.

### 1.3.2 bug fixes

- [PR 1295](https://github.com/grafana/tempo/pull/1295) **joe-elliott**: Fixed an issue which corrupted the start/end time ranges of Tempo searches that targeted ingesters.
