// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/google/uuid"
	"github.com/mrusme/journalist/ent/item"
	"github.com/mrusme/journalist/ent/predicate"
	"github.com/mrusme/journalist/ent/read"
	"github.com/mrusme/journalist/ent/user"
)

// ReadUpdate is the builder for updating Read entities.
type ReadUpdate struct {
	config
	hooks    []Hook
	mutation *ReadMutation
}

// Where appends a list predicates to the ReadUpdate builder.
func (ru *ReadUpdate) Where(ps ...predicate.Read) *ReadUpdate {
	ru.mutation.Where(ps...)
	return ru
}

// SetUserID sets the "user_id" field.
func (ru *ReadUpdate) SetUserID(u uuid.UUID) *ReadUpdate {
	ru.mutation.SetUserID(u)
	return ru
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (ru *ReadUpdate) SetNillableUserID(u *uuid.UUID) *ReadUpdate {
	if u != nil {
		ru.SetUserID(*u)
	}
	return ru
}

// SetItemID sets the "item_id" field.
func (ru *ReadUpdate) SetItemID(u uuid.UUID) *ReadUpdate {
	ru.mutation.SetItemID(u)
	return ru
}

// SetNillableItemID sets the "item_id" field if the given value is not nil.
func (ru *ReadUpdate) SetNillableItemID(u *uuid.UUID) *ReadUpdate {
	if u != nil {
		ru.SetItemID(*u)
	}
	return ru
}

// SetCreatedAt sets the "created_at" field.
func (ru *ReadUpdate) SetCreatedAt(t time.Time) *ReadUpdate {
	ru.mutation.SetCreatedAt(t)
	return ru
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ru *ReadUpdate) SetNillableCreatedAt(t *time.Time) *ReadUpdate {
	if t != nil {
		ru.SetCreatedAt(*t)
	}
	return ru
}

// SetUser sets the "user" edge to the User entity.
func (ru *ReadUpdate) SetUser(u *User) *ReadUpdate {
	return ru.SetUserID(u.ID)
}

// SetItem sets the "item" edge to the Item entity.
func (ru *ReadUpdate) SetItem(i *Item) *ReadUpdate {
	return ru.SetItemID(i.ID)
}

// Mutation returns the ReadMutation object of the builder.
func (ru *ReadUpdate) Mutation() *ReadMutation {
	return ru.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (ru *ReadUpdate) ClearUser() *ReadUpdate {
	ru.mutation.ClearUser()
	return ru
}

// ClearItem clears the "item" edge to the Item entity.
func (ru *ReadUpdate) ClearItem() *ReadUpdate {
	ru.mutation.ClearItem()
	return ru
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ru *ReadUpdate) Save(ctx context.Context) (int, error) {
	return withHooks(ctx, ru.sqlSave, ru.mutation, ru.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ru *ReadUpdate) SaveX(ctx context.Context) int {
	affected, err := ru.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ru *ReadUpdate) Exec(ctx context.Context) error {
	_, err := ru.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ru *ReadUpdate) ExecX(ctx context.Context) {
	if err := ru.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ru *ReadUpdate) check() error {
	if _, ok := ru.mutation.UserID(); ru.mutation.UserCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "Read.user"`)
	}
	if _, ok := ru.mutation.ItemID(); ru.mutation.ItemCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "Read.item"`)
	}
	return nil
}

func (ru *ReadUpdate) sqlSave(ctx context.Context) (n int, err error) {
	if err := ru.check(); err != nil {
		return n, err
	}
	_spec := sqlgraph.NewUpdateSpec(read.Table, read.Columns, sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID))
	if ps := ru.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ru.mutation.CreatedAt(); ok {
		_spec.SetField(read.FieldCreatedAt, field.TypeTime, value)
	}
	if ru.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   read.UserTable,
			Columns: []string{read.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ru.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   read.UserTable,
			Columns: []string{read.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ru.mutation.ItemCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   read.ItemTable,
			Columns: []string{read.ItemColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ru.mutation.ItemIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   read.ItemTable,
			Columns: []string{read.ItemColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, ru.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{read.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	ru.mutation.done = true
	return n, nil
}

// ReadUpdateOne is the builder for updating a single Read entity.
type ReadUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *ReadMutation
}

// SetUserID sets the "user_id" field.
func (ruo *ReadUpdateOne) SetUserID(u uuid.UUID) *ReadUpdateOne {
	ruo.mutation.SetUserID(u)
	return ruo
}

// SetNillableUserID sets the "user_id" field if the given value is not nil.
func (ruo *ReadUpdateOne) SetNillableUserID(u *uuid.UUID) *ReadUpdateOne {
	if u != nil {
		ruo.SetUserID(*u)
	}
	return ruo
}

// SetItemID sets the "item_id" field.
func (ruo *ReadUpdateOne) SetItemID(u uuid.UUID) *ReadUpdateOne {
	ruo.mutation.SetItemID(u)
	return ruo
}

// SetNillableItemID sets the "item_id" field if the given value is not nil.
func (ruo *ReadUpdateOne) SetNillableItemID(u *uuid.UUID) *ReadUpdateOne {
	if u != nil {
		ruo.SetItemID(*u)
	}
	return ruo
}

// SetCreatedAt sets the "created_at" field.
func (ruo *ReadUpdateOne) SetCreatedAt(t time.Time) *ReadUpdateOne {
	ruo.mutation.SetCreatedAt(t)
	return ruo
}

// SetNillableCreatedAt sets the "created_at" field if the given value is not nil.
func (ruo *ReadUpdateOne) SetNillableCreatedAt(t *time.Time) *ReadUpdateOne {
	if t != nil {
		ruo.SetCreatedAt(*t)
	}
	return ruo
}

// SetUser sets the "user" edge to the User entity.
func (ruo *ReadUpdateOne) SetUser(u *User) *ReadUpdateOne {
	return ruo.SetUserID(u.ID)
}

// SetItem sets the "item" edge to the Item entity.
func (ruo *ReadUpdateOne) SetItem(i *Item) *ReadUpdateOne {
	return ruo.SetItemID(i.ID)
}

// Mutation returns the ReadMutation object of the builder.
func (ruo *ReadUpdateOne) Mutation() *ReadMutation {
	return ruo.mutation
}

// ClearUser clears the "user" edge to the User entity.
func (ruo *ReadUpdateOne) ClearUser() *ReadUpdateOne {
	ruo.mutation.ClearUser()
	return ruo
}

// ClearItem clears the "item" edge to the Item entity.
func (ruo *ReadUpdateOne) ClearItem() *ReadUpdateOne {
	ruo.mutation.ClearItem()
	return ruo
}

// Where appends a list predicates to the ReadUpdate builder.
func (ruo *ReadUpdateOne) Where(ps ...predicate.Read) *ReadUpdateOne {
	ruo.mutation.Where(ps...)
	return ruo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (ruo *ReadUpdateOne) Select(field string, fields ...string) *ReadUpdateOne {
	ruo.fields = append([]string{field}, fields...)
	return ruo
}

// Save executes the query and returns the updated Read entity.
func (ruo *ReadUpdateOne) Save(ctx context.Context) (*Read, error) {
	return withHooks(ctx, ruo.sqlSave, ruo.mutation, ruo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (ruo *ReadUpdateOne) SaveX(ctx context.Context) *Read {
	node, err := ruo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (ruo *ReadUpdateOne) Exec(ctx context.Context) error {
	_, err := ruo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ruo *ReadUpdateOne) ExecX(ctx context.Context) {
	if err := ruo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ruo *ReadUpdateOne) check() error {
	if _, ok := ruo.mutation.UserID(); ruo.mutation.UserCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "Read.user"`)
	}
	if _, ok := ruo.mutation.ItemID(); ruo.mutation.ItemCleared() && !ok {
		return errors.New(`ent: clearing a required unique edge "Read.item"`)
	}
	return nil
}

func (ruo *ReadUpdateOne) sqlSave(ctx context.Context) (_node *Read, err error) {
	if err := ruo.check(); err != nil {
		return _node, err
	}
	_spec := sqlgraph.NewUpdateSpec(read.Table, read.Columns, sqlgraph.NewFieldSpec(read.FieldID, field.TypeUUID))
	id, ok := ruo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Read.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := ruo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, read.FieldID)
		for _, f := range fields {
			if !read.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != read.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := ruo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := ruo.mutation.CreatedAt(); ok {
		_spec.SetField(read.FieldCreatedAt, field.TypeTime, value)
	}
	if ruo.mutation.UserCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   read.UserTable,
			Columns: []string{read.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ruo.mutation.UserIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   read.UserTable,
			Columns: []string{read.UserColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(user.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if ruo.mutation.ItemCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   read.ItemTable,
			Columns: []string{read.ItemColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := ruo.mutation.ItemIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: false,
			Table:   read.ItemTable,
			Columns: []string{read.ItemColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(item.FieldID, field.TypeUUID),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Read{config: ruo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, ruo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{read.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	ruo.mutation.done = true
	return _node, nil
}
