// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Data Safe API
//
// APIs for using Oracle Data Safe.
//

package datasafe

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// FormatsForSensitiveType A list of library masking formats compatible with an existing sensitive type.
type FormatsForSensitiveType struct {

	// The OCID of the sensitive type.
	SensitiveTypeId *string `mandatory:"true" json:"sensitiveTypeId"`

	// An array of the library masking formats compatible with the sensitive type.
	MaskingFormats []FormatSummary `mandatory:"false" json:"maskingFormats"`
}

func (m FormatsForSensitiveType) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m FormatsForSensitiveType) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
