/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.plastic.PlasticBorders;
import com.jgoodies.looks.plastic.PlasticIconFactory;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import java.awt.Color;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class PlasticLookAndFeel
extends MetalLookAndFeel {
    public static final String BORDER_STYLE_KEY = "Plastic.borderStyle";
    public static final String IS_3D_KEY = "Plastic.is3D";
    public static final String DEFAULT_THEME_KEY = "Plastic.defaultTheme";
    public static final String HIGH_CONTRAST_FOCUS_ENABLED_KEY = "Plastic.highContrastFocus";
    protected static final String TAB_STYLE_KEY = "Plastic.tabStyle";
    public static final String TAB_STYLE_DEFAULT_VALUE = "default";
    public static final String TAB_STYLE_METAL_VALUE = "metal";
    private static final Object THEME_KEY = new StringBuffer("Plastic.theme");
    private static boolean useMetalTabs = LookUtils.getSystemProperty("Plastic.tabStyle", "").equalsIgnoreCase("metal");
    public static boolean useHighContrastFocusColors = LookUtils.getSystemProperty("Plastic.highContrastFocus") != null;
    private static List installedThemes;
    private static boolean is3DEnabled;
    private static Method getCurrentThemeMethod;
    private static final String THEME_CLASSNAME_PREFIX = "com.jgoodies.looks.plastic.theme.";

    public PlasticLookAndFeel() {
        PlasticLookAndFeel.getPlasticTheme();
    }

    public String getID() {
        return "JGoodies Plastic";
    }

    public String getName() {
        return "JGoodies Plastic";
    }

    public String getDescription() {
        return "The JGoodies Plastic Look and Feel - \u00a9 2001-2006 JGoodies Karsten Lentzsch";
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy policy = (FontPolicy)UIManager.get("Plastic.fontChoicePolicy");
        if (policy != null) {
            return policy;
        }
        FontPolicy defaultPolicy = FontPolicies.getDefaultPlasticPolicy();
        return FontPolicies.customSettingsPolicy(defaultPolicy);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put("Plastic.fontChoicePolicy", fontPolicy);
    }

    protected boolean is3DEnabled() {
        return is3DEnabled;
    }

    public static void set3DEnabled(boolean b) {
        is3DEnabled = b;
    }

    public static String getTabStyle() {
        return useMetalTabs ? TAB_STYLE_METAL_VALUE : TAB_STYLE_DEFAULT_VALUE;
    }

    public static void setTabStyle(String tabStyle) {
        useMetalTabs = tabStyle.equalsIgnoreCase(TAB_STYLE_METAL_VALUE);
    }

    public static boolean getHighContrastFocusColorsEnabled() {
        return useHighContrastFocusColors;
    }

    public static void setHighContrastFocusColorsEnabled(boolean b) {
        useHighContrastFocusColors = b;
    }

    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String plasticPrefix = "com.jgoodies.looks.plastic.Plastic";
        String commonPrefix = "com.jgoodies.looks.common.ExtBasic";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.jgoodies.looks.plastic.PlasticButtonUI", "ToggleButtonUI", "com.jgoodies.looks.plastic.PlasticToggleButtonUI", "ComboBoxUI", "com.jgoodies.looks.plastic.PlasticComboBoxUI", "ScrollBarUI", "com.jgoodies.looks.plastic.PlasticScrollBarUI", "SpinnerUI", "com.jgoodies.looks.plastic.PlasticSpinnerUI", "MenuBarUI", "com.jgoodies.looks.plastic.PlasticMenuBarUI", "ToolBarUI", "com.jgoodies.looks.plastic.PlasticToolBarUI", "MenuUI", "com.jgoodies.looks.plastic.PlasticMenuUI", "MenuItemUI", "com.jgoodies.looks.common.ExtBasicMenuItemUI", "CheckBoxMenuItemUI", "com.jgoodies.looks.common.ExtBasicCheckBoxMenuItemUI", "RadioButtonMenuItemUI", "com.jgoodies.looks.common.ExtBasicRadioButtonMenuItemUI", "PopupMenuUI", "com.jgoodies.looks.plastic.PlasticPopupMenuUI", "PopupMenuSeparatorUI", "com.jgoodies.looks.common.ExtBasicPopupMenuSeparatorUI", "OptionPaneUI", "com.jgoodies.looks.plastic.PlasticOptionPaneUI", "ScrollPaneUI", "com.jgoodies.looks.plastic.PlasticScrollPaneUI", "SplitPaneUI", "com.jgoodies.looks.plastic.PlasticSplitPaneUI", "TextAreaUI", "com.jgoodies.looks.plastic.PlasticTextAreaUI", "TreeUI", "com.jgoodies.looks.plastic.PlasticTreeUI", "InternalFrameUI", "com.jgoodies.looks.plastic.PlasticInternalFrameUI", "SeparatorUI", "com.jgoodies.looks.plastic.PlasticSeparatorUI", "ToolBarSeparatorUI", "com.jgoodies.looks.plastic.PlasticToolBarSeparatorUI"};
        table.putDefaults(uiDefaults);
        if (!useMetalTabs) {
            table.put("TabbedPaneUI", "com.jgoodies.looks.plastic.PlasticTabbedPaneUI");
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        boolean isVista = LookUtils.IS_OS_WINDOWS_VISTA;
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        Border buttonBorder = PlasticBorders.getButtonBorder();
        Border comboBoxButtonBorder = PlasticBorders.getComboBoxArrowButtonBorder();
        Border comboBoxEditorBorder = PlasticBorders.getComboBoxEditorBorder();
        Border menuItemBorder = PlasticBorders.getMenuItemBorder();
        Border textFieldBorder = PlasticBorders.getTextFieldBorder();
        Border toggleButtonBorder = PlasticBorders.getToggleButtonBorder();
        Border scrollPaneBorder = PlasticBorders.getScrollPaneBorder();
        BorderUIResource tableHeaderBorder = new BorderUIResource((Border)table.get("TableHeader.cellBorder"));
        BasicBorders.MarginBorder menuBarEmptyBorder = marginBorder;
        Border menuBarSeparatorBorder = PlasticBorders.getSeparatorBorder();
        Border menuBarEtchedBorder = PlasticBorders.getEtchedBorder();
        Border menuBarHeaderBorder = PlasticBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder toolBarEmptyBorder = marginBorder;
        Border toolBarSeparatorBorder = PlasticBorders.getSeparatorBorder();
        Border toolBarEtchedBorder = PlasticBorders.getEtchedBorder();
        Border toolBarHeaderBorder = PlasticBorders.getToolBarHeaderBorder();
        BorderUIResource internalFrameBorder = PlasticLookAndFeel.getInternalFrameBorder();
        BorderUIResource paletteBorder = PlasticLookAndFeel.getPaletteBorder();
        Color controlColor = table.getColor("control");
        Icon checkBoxIcon = PlasticIconFactory.getCheckBoxIcon();
        InsetsUIResource checkBoxMargin = new InsetsUIResource(2, 0, 2, 1);
        Insets buttonMargin = this.createButtonMargin();
        InsetsUIResource textInsets = isVista ? new InsetsUIResource(0, 1, 1, 1) : new InsetsUIResource(1, 1, 2, 1);
        InsetsUIResource wrappedTextInsets = isVista ? new InsetsUIResource(1, 1, 1, 1) : new InsetsUIResource(2, 1, 2, 1);
        Insets comboEditorBorderInsets = comboBoxEditorBorder.getBorderInsets(null);
        int comboBorderSize = comboEditorBorderInsets.left;
        int comboPopupBorderSize = 1;
        int comboRendererGap = textInsets.left + comboBorderSize - comboPopupBorderSize;
        EmptyBorder comboRendererBorder = new EmptyBorder(1, comboRendererGap, 1, comboRendererGap);
        Insets comboTableEditorInsets = new Insets(0, 0, 0, 0);
        InsetsUIResource menuItemMargin = new InsetsUIResource(3, 0, 3, 0);
        InsetsUIResource menuMargin = new InsetsUIResource(2, 4, 2, 4);
        MinimumSizedIcon menuItemCheckIcon = new MinimumSizedIcon();
        Icon checkBoxMenuItemIcon = PlasticIconFactory.getCheckBoxMenuItemIcon();
        Icon radioButtonMenuItemIcon = PlasticIconFactory.getRadioButtonMenuItemIcon();
        Color menuItemForeground = table.getColor("MenuItem.foreground");
        Color inactiveTextBackground = table.getColor("TextField.inactiveBackground");
        int treeFontSize = table.getFont("Tree.font").getSize();
        Integer rowHeight = new Integer(treeFontSize + 6);
        Icon treeExpandedIcon = PlasticIconFactory.getExpandedTreeIcon();
        Icon treeCollapsedIcon = PlasticIconFactory.getCollapsedTreeIcon();
        ColorUIResource gray = new ColorUIResource(Color.GRAY);
        Boolean is3D = this.is3DEnabled();
        Object[] defaults = new Object[]{"Button.border", buttonBorder, "Button.margin", buttonMargin, "CheckBox.margin", checkBoxMargin, "CheckBox.icon", checkBoxIcon, "CheckBoxMenuItem.border", menuItemBorder, "CheckBoxMenuItem.margin", menuItemMargin, "CheckBoxMenuItem.checkIcon", checkBoxMenuItemIcon, "CheckBoxMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "CheckBoxMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "CheckBoxMenuItem.acceleratorForeground", menuItemForeground, "CheckBoxMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "CheckBoxMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "ComboBox.selectionForeground", PlasticLookAndFeel.getMenuSelectedForeground(), "ComboBox.selectionBackground", PlasticLookAndFeel.getMenuSelectedBackground(), "ComboBox.arrowButtonBorder", comboBoxButtonBorder, "ComboBox.editorBorder", comboBoxEditorBorder, "ComboBox.editorColumns", new Integer(5), "ComboBox.editorBorderInsets", comboEditorBorderInsets, "ComboBox.editorInsets", textInsets, "ComboBox.tableEditorInsets", comboTableEditorInsets, "ComboBox.rendererBorder", comboRendererBorder, "EditorPane.margin", wrappedTextInsets, "InternalFrame.border", internalFrameBorder, "InternalFrame.paletteBorder", paletteBorder, "List.font", PlasticLookAndFeel.getControlTextFont(), "Menu.border", PlasticBorders.getMenuBorder(), "Menu.margin", menuMargin, "Menu.arrowIcon", PlasticIconFactory.getMenuArrowIcon(), "MenuBar.emptyBorder", menuBarEmptyBorder, "MenuBar.separatorBorder", menuBarSeparatorBorder, "MenuBar.etchedBorder", menuBarEtchedBorder, "MenuBar.headerBorder", menuBarHeaderBorder, "MenuItem.border", menuItemBorder, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.margin", menuItemMargin, "MenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "MenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "MenuItem.acceleratorForeground", menuItemForeground, "MenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "MenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "OptionPane.errorIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Error.png"), "OptionPane.informationIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Inform.png"), "OptionPane.warningIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Warn.png"), "OptionPane.questionIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Question.png"), "FileView.computerIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/Computer.gif"), "FileView.directoryIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "FileView.fileIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/File.gif"), "FileView.floppyDriveIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/FloppyDrive.gif"), "FileView.hardDriveIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/HardDrive.gif"), "FileChooser.homeFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/HomeFolder.gif"), "FileChooser.newFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/NewFolder.gif"), "FileChooser.upFolderIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/UpFolder.gif"), "Tree.closedIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeClosed.gif"), "Tree.openIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeOpen.gif"), "Tree.leafIcon", PlasticLookAndFeel.makeIcon(this.getClass(), "icons/TreeLeaf.gif"), "FormattedTextField.border", textFieldBorder, "FormattedTextField.margin", textInsets, "PasswordField.border", textFieldBorder, "PasswordField.margin", textInsets, "PopupMenu.border", PlasticBorders.getPopupMenuBorder(), "PopupMenu.noMarginBorder", PlasticBorders.getNoMarginPopupMenuBorder(), "PopupMenuSeparator.margin", new InsetsUIResource(3, 4, 3, 4), "RadioButton.margin", checkBoxMargin, "RadioButtonMenuItem.border", menuItemBorder, "RadioButtonMenuItem.checkIcon", radioButtonMenuItemIcon, "RadioButtonMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.background", PlasticLookAndFeel.getMenuItemBackground(), "RadioButtonMenuItem.selectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.selectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "RadioButtonMenuItem.acceleratorForeground", menuItemForeground, "RadioButtonMenuItem.acceleratorSelectionForeground", PlasticLookAndFeel.getMenuItemSelectedForeground(), "RadioButtonMenuItem.acceleratorSelectionBackground", PlasticLookAndFeel.getMenuItemSelectedBackground(), "Separator.foreground", PlasticLookAndFeel.getControlDarkShadow(), "ScrollPane.border", scrollPaneBorder, "ScrollPane.etchedBorder", scrollPaneBorder, "SimpleInternalFrame.activeTitleForeground", PlasticLookAndFeel.getSimpleInternalFrameForeground(), "SimpleInternalFrame.activeTitleBackground", PlasticLookAndFeel.getSimpleInternalFrameBackground(), "Spinner.border", PlasticBorders.getFlush3DBorder(), "Spinner.defaultEditorInsets", textInsets, "SplitPane.dividerSize", new Integer(7), "TabbedPane.focus", PlasticLookAndFeel.getFocusColor(), "TabbedPane.tabInsets", new InsetsUIResource(1, 9, 1, 8), "Table.foreground", table.get("textText"), "Table.gridColor", controlColor, "Table.scrollPaneBorder", scrollPaneBorder, "TableHeader.cellBorder", tableHeaderBorder, "TextArea.inactiveBackground", inactiveTextBackground, "TextArea.margin", wrappedTextInsets, "TextField.border", textFieldBorder, "TextField.margin", textInsets, "TitledBorder.font", PlasticLookAndFeel.getTitleTextFont(), "TitledBorder.titleColor", PlasticLookAndFeel.getTitleTextColor(), "ToggleButton.border", toggleButtonBorder, "ToggleButton.margin", buttonMargin, "ToolBar.emptyBorder", toolBarEmptyBorder, "ToolBar.separatorBorder", toolBarSeparatorBorder, "ToolBar.etchedBorder", toolBarEtchedBorder, "ToolBar.headerBorder", toolBarHeaderBorder, "ToolTip.hideAccelerator", Boolean.TRUE, "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.line", gray, "Tree.hash", gray, "Tree.rowHeight", rowHeight, "Button.is3DEnabled", is3D, "ComboBox.is3DEnabled", is3D, "MenuBar.is3DEnabled", is3D, "ToolBar.is3DEnabled", is3D, "ScrollBar.is3DEnabled", is3D, "ToggleButton.is3DEnabled", is3D, "CheckBox.border", marginBorder, "RadioButton.border", marginBorder, "ProgressBar.selectionForeground", PlasticLookAndFeel.getSystemTextColor(), "ProgressBar.selectionBackground", PlasticLookAndFeel.getSystemTextColor()};
        table.putDefaults(defaults);
        String soundPathPrefix = "/javax/swing/plaf/metal/";
        Object[] auditoryCues = (Object[])table.get("AuditoryCues.allAuditoryCues");
        if (auditoryCues != null) {
            Object[] audioDefaults = new String[auditoryCues.length * 2];
            for (int i = 0; i < auditoryCues.length; ++i) {
                Object auditoryCue;
                audioDefaults[2 * i] = auditoryCue = auditoryCues[i];
                audioDefaults[2 * i + 1] = soundPathPrefix + table.getString(auditoryCue);
            }
            table.putDefaults(audioDefaults);
        }
    }

    protected Insets createButtonMargin() {
        int pad;
        int n = pad = Options.getUseNarrowButtons() ? 4 : 14;
        return LookUtils.IS_OS_WINDOWS_VISTA ? new InsetsUIResource(0, pad, 1, pad) : (LookUtils.IS_LOW_RESOLUTION ? new InsetsUIResource(1, pad, 1, pad) : new InsetsUIResource(2, pad, 3, pad));
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("unifiedControlShadow", table.getColor("controlDkShadow"));
        table.put("primaryControlHighlight", PlasticLookAndFeel.getPrimaryControlHighlight());
    }

    public static PlasticTheme createMyDefaultTheme() {
        PlasticTheme result;
        String defaultName = LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? "ExperienceBlue" : (LookUtils.IS_OS_WINDOWS_MODERN ? "DesertBluer" : "SkyBlue");
        String userName = LookUtils.getSystemProperty(DEFAULT_THEME_KEY, "");
        boolean overridden = userName.length() > 0;
        String themeName = overridden ? userName : defaultName;
        PlasticTheme theme = PlasticLookAndFeel.createTheme(themeName);
        PlasticTheme plasticTheme = result = theme != null ? theme : new SkyBluer();
        if (overridden) {
            String className = result.getClass().getName().substring(THEME_CLASSNAME_PREFIX.length());
            if (className.equals(userName)) {
                LookUtils.log("I have successfully installed the '" + result.getName() + "' theme.");
            } else {
                LookUtils.log("I could not install the Plastic theme '" + userName + "'.");
                LookUtils.log("I have installed the '" + result.getName() + "' theme, instead.");
            }
        }
        return result;
    }

    public static List getInstalledThemes() {
        if (null == installedThemes) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        Collections.sort(installedThemes, new Comparator(){

            public int compare(Object o1, Object o2) {
                MetalTheme theme1 = (MetalTheme)o1;
                MetalTheme theme2 = (MetalTheme)o2;
                return theme1.getName().compareTo(theme2.getName());
            }
        });
        return installedThemes;
    }

    protected static void installDefaultThemes() {
        installedThemes = new ArrayList();
        String[] themeNames = new String[]{"BrownSugar", "DarkStar", "DesertBlue", "DesertBluer", "DesertGreen", "DesertRed", "DesertYellow", "ExperienceBlue", "ExperienceGreen", "Silver", "SkyBlue", "SkyBluer", "SkyGreen", "SkyKrupp", "SkyPink", "SkyRed", "SkyYellow"};
        for (int i = themeNames.length - 1; i >= 0; --i) {
            PlasticLookAndFeel.installTheme(PlasticLookAndFeel.createTheme(themeNames[i]));
        }
    }

    protected static PlasticTheme createTheme(String themeName) {
        String className = THEME_CLASSNAME_PREFIX + themeName;
        try {
            Class<?> cl = Class.forName(className);
            return (PlasticTheme)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        LookUtils.log("Can't create theme " + className);
        return null;
    }

    public static void installTheme(PlasticTheme theme) {
        if (null == installedThemes) {
            PlasticLookAndFeel.installDefaultThemes();
        }
        installedThemes.add(theme);
    }

    public static PlasticTheme getPlasticTheme() {
        MetalTheme theme;
        if (LookUtils.IS_JAVA_5_OR_LATER && (theme = PlasticLookAndFeel.getCurrentTheme0()) instanceof PlasticTheme) {
            return (PlasticTheme)theme;
        }
        PlasticTheme uimanagerTheme = (PlasticTheme)UIManager.get(THEME_KEY);
        if (uimanagerTheme != null) {
            return uimanagerTheme;
        }
        PlasticTheme initialTheme = PlasticLookAndFeel.createMyDefaultTheme();
        PlasticLookAndFeel.setPlasticTheme(initialTheme);
        return initialTheme;
    }

    public static void setPlasticTheme(PlasticTheme theme) {
        if (theme == null) {
            throw new NullPointerException("The theme must not be null.");
        }
        UIManager.put(THEME_KEY, theme);
        PlasticLookAndFeel.setCurrentTheme(theme);
    }

    public static PlasticTheme getMyCurrentTheme() {
        return PlasticLookAndFeel.getPlasticTheme();
    }

    public static void setMyCurrentTheme(PlasticTheme theme) {
        PlasticLookAndFeel.setPlasticTheme(theme);
    }

    public static BorderUIResource getInternalFrameBorder() {
        return new BorderUIResource(PlasticBorders.getInternalFrameBorder());
    }

    public static BorderUIResource getPaletteBorder() {
        return new BorderUIResource(PlasticBorders.getPaletteBorder());
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlHighlight();
    }

    public static ColorUIResource getPrimaryControlInfo() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlInfo();
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControlShadow();
    }

    public static ColorUIResource getPrimaryControl() {
        return PlasticLookAndFeel.getPlasticTheme().getPrimaryControl();
    }

    public static ColorUIResource getControlHighlight() {
        return PlasticLookAndFeel.getPlasticTheme().getControlHighlight();
    }

    public static ColorUIResource getControlDarkShadow() {
        return PlasticLookAndFeel.getPlasticTheme().getControlDarkShadow();
    }

    public static ColorUIResource getControl() {
        return PlasticLookAndFeel.getPlasticTheme().getControl();
    }

    public static ColorUIResource getFocusColor() {
        return PlasticLookAndFeel.getPlasticTheme().getFocusColor();
    }

    public static ColorUIResource getMenuItemBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemBackground();
    }

    public static ColorUIResource getMenuItemSelectedBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemSelectedBackground();
    }

    public static ColorUIResource getMenuItemSelectedForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getMenuItemSelectedForeground();
    }

    public static ColorUIResource getWindowTitleBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleBackground();
    }

    public static ColorUIResource getWindowTitleForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleForeground();
    }

    public static ColorUIResource getWindowTitleInactiveBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleInactiveBackground();
    }

    public static ColorUIResource getWindowTitleInactiveForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getWindowTitleInactiveForeground();
    }

    public static ColorUIResource getSimpleInternalFrameForeground() {
        return PlasticLookAndFeel.getPlasticTheme().getSimpleInternalFrameForeground();
    }

    public static ColorUIResource getSimpleInternalFrameBackground() {
        return PlasticLookAndFeel.getPlasticTheme().getSimpleInternalFrameBackground();
    }

    public static ColorUIResource getTitleTextColor() {
        return PlasticLookAndFeel.getPlasticTheme().getTitleTextColor();
    }

    public static FontUIResource getTitleTextFont() {
        return PlasticLookAndFeel.getPlasticTheme().getTitleTextFont();
    }

    private static MetalTheme getCurrentTheme0() {
        if (getCurrentThemeMethod != null) {
            try {
                return (MetalTheme)getCurrentThemeMethod.invoke(null, null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Method getMethodGetCurrentTheme() {
        try {
            Class clazz = MetalLookAndFeel.class;
            return clazz.getMethod("getCurrentTheme", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static {
        is3DEnabled = false;
        getCurrentThemeMethod = null;
        if (LookUtils.IS_JAVA_5_OR_LATER) {
            getCurrentThemeMethod = PlasticLookAndFeel.getMethodGetCurrentTheme();
        }
    }
}

