/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.gradle.api.internal.tasks.compile.CompilationClassBackupService;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.ContextAwareJavaCompiler;
import org.gradle.api.internal.tasks.compile.IncrementalCompilationAwareJavaCompiler;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants.ConstantsAnalysisResult;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.reflect.DirectInstantiator;

public class JdkTools {
    private static final String DEFAULT_COMPILER_IMPL_NAME = "com.sun.tools.javac.api.JavacTool";
    private static final String DEFAULT_CONTEXT_IMPL_NAME = "com.sun.tools.javac.util.Context";
    private final ClassLoader isolatedToolsLoader;
    private Class<JavaCompiler.CompilationTask> incrementalCompileTaskClass;

    JdkTools(List<File> compilerPlugins) {
        DefaultClassLoaderFactory defaultClassLoaderFactory = new DefaultClassLoaderFactory();
        ClassLoader filteringClassLoader = this.getSystemFilteringClassLoader((ClassLoaderFactory)defaultClassLoaderFactory);
        this.isolatedToolsLoader = VisitableURLClassLoader.fromClassPath((String)"jdk-tools", (ClassLoader)filteringClassLoader, (ClassPath)DefaultClassPath.of(compilerPlugins));
    }

    private ClassLoader getSystemFilteringClassLoader(ClassLoaderFactory classLoaderFactory) {
        FilteringClassLoader.Spec filterSpec = new FilteringClassLoader.Spec();
        filterSpec.allowPackage("com.sun.tools");
        filterSpec.allowPackage("com.sun.source");
        return classLoaderFactory.createFilteringClassLoader(this.getClass().getClassLoader(), filterSpec);
    }

    public ContextAwareJavaCompiler getSystemJavaCompiler() {
        return new DefaultIncrementalAwareCompiler(this.buildJavaCompiler());
    }

    private JavacTool buildJavaCompiler() {
        return JavacTool.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCompilerTask() {
        if (this.incrementalCompileTaskClass == null) {
            JdkTools jdkTools = this;
            synchronized (jdkTools) {
                try {
                    this.incrementalCompileTaskClass = (Class)Cast.uncheckedCast(this.isolatedToolsLoader.loadClass("org.gradle.internal.compiler.java.IncrementalCompileTask"));
                }
                catch (ClassNotFoundException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }
    }

    private class DefaultIncrementalAwareCompiler
    implements IncrementalCompilationAwareJavaCompiler {
        private final JavacTool delegate;

        private DefaultIncrementalAwareCompiler(JavacTool delegate) {
            this.delegate = delegate;
        }

        @Override
        public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
            return this.delegate.getTask(out, fileManager, (DiagnosticListener)diagnosticListener, (Iterable)options, (Iterable)classes, (Iterable)compilationUnits);
        }

        @Override
        public JavacTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits, Context context) {
            return this.delegate.getTask(out, fileManager, diagnosticListener, options, classes, compilationUnits, context);
        }

        @Override
        public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
            return this.delegate.getStandardFileManager((DiagnosticListener)diagnosticListener, locale, charset);
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
            return this.delegate.run(in, out, err, arguments);
        }

        @Override
        public Set<SourceVersion> getSourceVersions() {
            return this.delegate.getSourceVersions();
        }

        @Override
        public int isSupportedOption(String option) {
            return this.delegate.isSupportedOption(option);
        }

        @Override
        public JavaCompiler.CompilationTask makeIncremental(JavaCompiler.CompilationTask task, Map<String, Set<String>> sourceToClassMapping, ConstantsAnalysisResult constantsAnalysisResult, CompilationSourceDirs compilationSourceDirs, CompilationClassBackupService classBackupService) {
            JdkTools.this.ensureCompilerTask();
            Object[] objectArray = new Object[6];
            objectArray[0] = task;
            objectArray[1] = compilationSourceDirs::relativize;
            objectArray[2] = classBackupService::maybeBackupClassFile;
            objectArray[3] = sourceToClassMapping::putAll;
            objectArray[4] = constantsAnalysisResult::addPublicDependent;
            objectArray[5] = constantsAnalysisResult::addPrivateDependent;
            return (JavaCompiler.CompilationTask)DirectInstantiator.instantiate((Class)JdkTools.this.incrementalCompileTaskClass, (Object[])objectArray);
        }
    }
}

