/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStream;
import java.util.ArrayList;

public abstract class AbstractSerializationStreamReader
extends AbstractSerializationStream
implements SerializationStreamReader {
    private static final double TWO_PWR_15_DBL = 32768.0;
    private static final double TWO_PWR_16_DBL = 65536.0;
    private static final double TWO_PWR_22_DBL = 4194304.0;
    private static final double TWO_PWR_31_DBL = 2.147483648E9;
    private static final double TWO_PWR_32_DBL = 4.294967296E9;
    private static final double TWO_PWR_44_DBL = 1.7592186044416E13;
    private static final double TWO_PWR_63_DBL = 9.223372036854776E18;
    private ArrayList<Object> seenArray = new ArrayList();

    public static long fromDoubles(double lowDouble, double highDouble) {
        long high = AbstractSerializationStreamReader.fromDouble(highDouble);
        long low = AbstractSerializationStreamReader.fromDouble(lowDouble);
        return high + low;
    }

    private static long fromDouble(double value) {
        if (Double.isNaN(value)) {
            return 0L;
        }
        if (value < -9.223372036854776E18) {
            return Long.MIN_VALUE;
        }
        if (value >= 9.223372036854776E18) {
            return Long.MAX_VALUE;
        }
        boolean negative = false;
        if (value < 0.0) {
            negative = true;
            value = -value;
        }
        int a2 = 0;
        if (value >= 1.7592186044416E13) {
            a2 = (int)(value / 1.7592186044416E13);
            value -= (double)a2 * 1.7592186044416E13;
        }
        int a1 = 0;
        if (value >= 4194304.0) {
            a1 = (int)(value / 4194304.0);
            value -= (double)a1 * 4194304.0;
        }
        int a0 = (int)value;
        long result = (long)a2 << 44 | (long)a1 << 22 | (long)a0;
        if (negative) {
            result = -result;
        }
        return result;
    }

    public void prepareToRead(String encoded) throws SerializationException {
        this.seenArray.clear();
        this.setVersion(this.readInt());
        this.setFlags(this.readInt());
    }

    @Override
    public final Object readObject() throws SerializationException {
        int token = this.readInt();
        if (token < 0) {
            return this.seenArray.get(-(token + 1));
        }
        String typeSignature = this.getString(token);
        if (typeSignature == null) {
            return null;
        }
        return this.deserialize(typeSignature);
    }

    protected abstract Object deserialize(String var1) throws SerializationException;

    protected final Object getDecodedObject(int index) {
        return this.seenArray.get(index - 1);
    }

    protected abstract String getString(int var1);

    protected final void rememberDecodedObject(int index, Object o) {
        this.seenArray.set(index - 1, o);
    }

    protected final int reserveDecodedObjectIndex() {
        this.seenArray.add(null);
        return this.seenArray.size();
    }
}

