/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderImpl;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.deserialization.ContractDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.TypeDeserializer;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J:\u0010\b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl;", "Lorg/jetbrains/kotlin/serialization/deserialization/ContractDeserializer;", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "<init>", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "deserializeContractFromFunction", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor$UserDataKey;", "Lorg/jetbrains/kotlin/contracts/description/AbstractContractProvider;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "ownerFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "typeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "ContractDeserializationWorker", "frontend"})
public final class ContractDeserializerImpl
implements ContractDeserializer {
    @NotNull
    private final DeserializationConfiguration configuration;
    @NotNull
    private final StorageManager storageManager;

    public ContractDeserializerImpl(@NotNull DeserializationConfiguration configuration2, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.configuration = configuration2;
        this.storageManager = storageManager;
    }

    @Nullable
    public Pair<CallableDescriptor.UserDataKey<?>, AbstractContractProvider> deserializeContractFromFunction(@NotNull ProtoBuf.Function proto, @NotNull FunctionDescriptor ownerFunction, @NotNull TypeTable typeTable, @NotNull TypeDeserializer typeDeserializer) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(ownerFunction, "ownerFunction");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        Intrinsics.checkNotNullParameter(typeDeserializer, "typeDeserializer");
        if (!proto.hasContract()) {
            return null;
        }
        if (!this.configuration.getReadDeserializedContracts()) {
            return null;
        }
        ContractDeserializationWorker worker = new ContractDeserializationWorker(typeTable, typeDeserializer, ownerFunction, this.storageManager);
        ProtoBuf.Contract contract = proto.getContract();
        Intrinsics.checkNotNullExpressionValue(contract, "getContract(...)");
        ContractDescription contractDescription = worker.deserializeContract(contract);
        if (contractDescription == null) {
            return null;
        }
        ContractDescription contract2 = contractDescription;
        return TuplesKt.to(ContractProviderKey.INSTANCE, new ContractProviderImpl(contract2));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002,-B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u0016H\u0002J\f\u0010+\u001a\u00020\u001c*\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker;", "", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "typeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "ownerFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "deserializeContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "deserializePossiblyConditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect;", "deserializeSimpleEffect", "deserializeExpression", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression;", "extractPrimitiveExpression", "primitiveType", "Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$PrimitiveExpressionType;", "invertIfNecessary", "shouldInvert", "", "extractVariable", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "toDescriptorInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "extractType", "Lorg/jetbrains/kotlin/types/KotlinType;", "deserializeConstant", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "value", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "getComplexType", "Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$ComplexExpressionType;", "getPrimitiveType", "hasType", "PrimitiveExpressionType", "ComplexExpressionType", "frontend"})
    @SourceDebugExtension(value={"SMAP\nContractDeserializerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractDeserializerImpl.kt\norg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n1557#2:250\n1628#2,3:251\n1628#2,3:254\n2669#2,7:257\n1628#2,3:264\n2669#2,7:267\n*S KotlinDebug\n*F\n+ 1 ContractDeserializerImpl.kt\norg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker\n*L\n62#1:250\n62#1:251,3\n113#1:254,3\n114#1:257,7\n118#1:264,3\n119#1:267,7\n*E\n"})
    private static final class ContractDeserializationWorker {
        @NotNull
        private final TypeTable typeTable;
        @NotNull
        private final TypeDeserializer typeDeserializer;
        @NotNull
        private final FunctionDescriptor ownerFunction;
        @NotNull
        private final StorageManager storageManager;

        public ContractDeserializationWorker(@NotNull TypeTable typeTable, @NotNull TypeDeserializer typeDeserializer, @NotNull FunctionDescriptor ownerFunction, @NotNull StorageManager storageManager) {
            Intrinsics.checkNotNullParameter(typeTable, "typeTable");
            Intrinsics.checkNotNullParameter(typeDeserializer, "typeDeserializer");
            Intrinsics.checkNotNullParameter(ownerFunction, "ownerFunction");
            Intrinsics.checkNotNullParameter(storageManager, "storageManager");
            this.typeTable = typeTable;
            this.typeDeserializer = typeDeserializer;
            this.ownerFunction = ownerFunction;
            this.storageManager = storageManager;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ContractDescription deserializeContract(@NotNull ProtoBuf.Contract proto) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(proto, "proto");
            List<ProtoBuf.Effect> list = proto.getEffectList();
            Intrinsics.checkNotNullExpressionValue(list, "getEffectList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Effect effect = (ProtoBuf.Effect)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                EffectDeclaration effectDeclaration = this.deserializePossiblyConditionalEffect((ProtoBuf.Effect)it);
                if (effectDeclaration == null) {
                    return null;
                }
                collection.add(effectDeclaration);
            }
            List effects = (List)destination$iv$iv;
            return new ContractDescription(effects, this.ownerFunction, this.storageManager);
        }

        private final EffectDeclaration deserializePossiblyConditionalEffect(ProtoBuf.Effect proto) {
            if (proto.hasConclusionOfConditionalEffect()) {
                ProtoBuf.Expression expression2 = proto.getConclusionOfConditionalEffect();
                Intrinsics.checkNotNullExpressionValue(expression2, "getConclusionOfConditionalEffect(...)");
                BooleanExpression booleanExpression = this.deserializeExpression(expression2);
                if (booleanExpression == null) {
                    return null;
                }
                BooleanExpression conclusion = booleanExpression;
                EffectDeclaration effectDeclaration = this.deserializeSimpleEffect(proto);
                if (effectDeclaration == null) {
                    return null;
                }
                EffectDeclaration effect = effectDeclaration;
                return new ConditionalEffectDeclaration(effect, conclusion);
            }
            return this.deserializeSimpleEffect(proto);
        }

        private final EffectDeclaration deserializeSimpleEffect(ProtoBuf.Effect proto) {
            EffectDeclaration effectDeclaration;
            ProtoBuf.Effect.EffectType type2;
            if (!proto.hasEffectType()) {
                return null;
            }
            ProtoBuf.Effect.EffectType effectType = type2 = proto.getEffectType();
            Intrinsics.checkNotNull(effectType);
            switch (WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
                case 1: {
                    ConstantReference constantReference;
                    ProtoBuf.Expression argument;
                    List<ProtoBuf.Expression> list = proto.getEffectConstructorArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list, "getEffectConstructorArgumentList(...)");
                    ProtoBuf.Expression expression2 = argument = kotlin.collections.CollectionsKt.getOrNull(list, 0);
                    if (expression2 == null) {
                        constantReference = ConstantReference.Companion.getWILDCARD();
                    } else {
                        BooleanExpression booleanExpression = this.deserializeExpression(expression2);
                        constantReference = booleanExpression instanceof ConstantReference ? (ConstantReference)((Object)booleanExpression) : null;
                        if (constantReference == null) {
                            return null;
                        }
                    }
                    ConstantReference returnValue = constantReference;
                    effectDeclaration = new ReturnsEffectDeclaration(returnValue);
                    break;
                }
                case 2: {
                    effectDeclaration = new ReturnsEffectDeclaration(ConstantReference.Companion.getNOT_NULL());
                    break;
                }
                case 3: {
                    EventOccurrencesRange eventOccurrencesRange;
                    List<ProtoBuf.Expression> list = proto.getEffectConstructorArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list, "getEffectConstructorArgumentList(...)");
                    ProtoBuf.Expression expression3 = kotlin.collections.CollectionsKt.getOrNull(list, 0);
                    if (expression3 == null) {
                        return null;
                    }
                    ProtoBuf.Expression argument = expression3;
                    VariableReference variableReference = this.extractVariable(argument);
                    if (variableReference == null) {
                        return null;
                    }
                    VariableReference callable = variableReference;
                    if (proto.hasKind()) {
                        ProtoBuf.Effect.InvocationKind invocationKind = proto.getKind();
                        Intrinsics.checkNotNullExpressionValue(invocationKind, "getKind(...)");
                        eventOccurrencesRange = this.toDescriptorInvocationKind(invocationKind);
                        if (eventOccurrencesRange == null) {
                            return null;
                        }
                    } else {
                        eventOccurrencesRange = EventOccurrencesRange.UNKNOWN;
                    }
                    EventOccurrencesRange invocationKind = eventOccurrencesRange;
                    effectDeclaration = new CallsEffectDeclaration(callable, invocationKind);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return effectDeclaration;
        }

        /*
         * WARNING - void declaration
         */
        private final BooleanExpression deserializeExpression(ProtoBuf.Expression proto) {
            BooleanExpression booleanExpression;
            PrimitiveExpressionType primitiveType = this.getPrimitiveType(proto);
            BooleanExpression primitiveExpression = this.extractPrimitiveExpression(proto, primitiveType);
            ComplexExpressionType complexType = this.getComplexType(proto);
            List childs = new ArrayList();
            CollectionsKt.addIfNotNull(childs, primitiveExpression);
            ComplexExpressionType complexExpressionType = complexType;
            switch (complexExpressionType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[complexExpressionType.ordinal()]) {
                case 1: {
                    BooleanExpression it;
                    List<ProtoBuf.Expression> list = proto.getAndArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list, "getAndArgumentList(...)");
                    Iterable $this$mapTo$iv = list;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        ProtoBuf.Expression expression2 = (ProtoBuf.Expression)item$iv;
                        Collection collection = childs;
                        boolean bl = false;
                        Intrinsics.checkNotNull(it);
                        BooleanExpression booleanExpression2 = this.deserializeExpression((ProtoBuf.Expression)((Object)it));
                        if (booleanExpression2 == null) {
                            return null;
                        }
                        collection.add(booleanExpression2);
                    }
                    Iterable $this$reduce$iv = childs;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void booleanExpression3;
                        it = (BooleanExpression)iterator$iv.next();
                        BooleanExpression acc = (BooleanExpression)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = new LogicalAnd(acc, (BooleanExpression)booleanExpression3);
                    }
                    booleanExpression = (BooleanExpression)accumulator$iv;
                    break;
                }
                case 2: {
                    BooleanExpression it;
                    ProtoBuf.Expression booleanExpression3;
                    List<ProtoBuf.Expression> list = proto.getOrArgumentList();
                    Intrinsics.checkNotNullExpressionValue(list, "getOrArgumentList(...)");
                    Iterable $this$mapTo$iv = list;
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        booleanExpression3 = (ProtoBuf.Expression)item$iv;
                        Collection collection = childs;
                        boolean bl = false;
                        Intrinsics.checkNotNull(it);
                        BooleanExpression booleanExpression4 = this.deserializeExpression((ProtoBuf.Expression)((Object)it));
                        if (booleanExpression4 == null) {
                            return null;
                        }
                        collection.add(booleanExpression4);
                    }
                    Iterable $this$reduce$iv = childs;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        it = (BooleanExpression)iterator$iv.next();
                        BooleanExpression acc = (BooleanExpression)accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = new LogicalOr(acc, (BooleanExpression)((Object)booleanExpression3));
                    }
                    booleanExpression = (BooleanExpression)accumulator$iv;
                    break;
                }
                case -1: {
                    booleanExpression = primitiveExpression;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return booleanExpression;
        }

        private final BooleanExpression extractPrimitiveExpression(ProtoBuf.Expression proto, PrimitiveExpressionType primitiveType) {
            BooleanExpression booleanExpression;
            Boolean bl = Flags.IS_NEGATED.get(proto.getFlags());
            Intrinsics.checkNotNullExpressionValue(bl, "get(...)");
            boolean isInverted = bl;
            PrimitiveExpressionType primitiveExpressionType = primitiveType;
            switch (primitiveExpressionType == null ? -1 : WhenMappings.$EnumSwitchMapping$2[primitiveExpressionType.ordinal()]) {
                case 1: 
                case 2: {
                    VariableReference variableReference = this.extractVariable(proto);
                    BooleanVariableReference booleanVariableReference = variableReference instanceof BooleanVariableReference ? (BooleanVariableReference)variableReference : null;
                    if (booleanVariableReference != null) {
                        booleanExpression = this.invertIfNecessary(booleanVariableReference, isInverted);
                        break;
                    }
                    booleanExpression = null;
                    break;
                }
                case 3: {
                    ProtoBuf.Expression.ConstantValue constantValue = proto.getConstantValue();
                    Intrinsics.checkNotNullExpressionValue(constantValue, "getConstantValue(...)");
                    ConstantReference constantReference = this.deserializeConstant(constantValue);
                    BooleanConstantReference booleanConstantReference = constantReference instanceof BooleanConstantReference ? (BooleanConstantReference)constantReference : null;
                    if (booleanConstantReference != null) {
                        booleanExpression = this.invertIfNecessary(booleanConstantReference, isInverted);
                        break;
                    }
                    booleanExpression = null;
                    break;
                }
                case 4: {
                    VariableReference variableReference = this.extractVariable(proto);
                    if (variableReference == null) {
                        return null;
                    }
                    VariableReference variable = variableReference;
                    KotlinType kotlinType = this.extractType(proto);
                    if (kotlinType == null) {
                        return null;
                    }
                    KotlinType type2 = kotlinType;
                    booleanExpression = new IsInstancePredicate(variable, type2, isInverted);
                    break;
                }
                case 5: {
                    VariableReference variableReference = this.extractVariable(proto);
                    if (variableReference == null) {
                        return null;
                    }
                    VariableReference variable = variableReference;
                    booleanExpression = new IsNullPredicate(variable, isInverted);
                    break;
                }
                case -1: {
                    booleanExpression = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return booleanExpression;
        }

        private final BooleanExpression invertIfNecessary(BooleanExpression $this$invertIfNecessary, boolean shouldInvert) {
            return shouldInvert ? (BooleanExpression)new LogicalNot($this$invertIfNecessary) : $this$invertIfNecessary;
        }

        private final VariableReference extractVariable(ProtoBuf.Expression proto) {
            ParameterDescriptor parameterDescriptor;
            if (!proto.hasValueParameterReference()) {
                return null;
            }
            if (proto.getValueParameterReference() == 0) {
                ReceiverParameterDescriptor receiverParameterDescriptor = this.ownerFunction.getExtensionReceiverParameter();
                if (receiverParameterDescriptor == null) {
                    return null;
                }
                parameterDescriptor = receiverParameterDescriptor;
            } else {
                List<ValueParameterDescriptor> list = this.ownerFunction.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
                ValueParameterDescriptor valueParameterDescriptor = kotlin.collections.CollectionsKt.getOrNull(list, proto.getValueParameterReference() - 1);
                if (valueParameterDescriptor == null) {
                    return null;
                }
                parameterDescriptor = valueParameterDescriptor;
            }
            ParameterDescriptor parameterDescriptor2 = parameterDescriptor;
            return !KotlinBuiltIns.isBoolean(parameterDescriptor2.getType()) ? new VariableReference(parameterDescriptor2) : (VariableReference)new BooleanVariableReference(parameterDescriptor2);
        }

        private final EventOccurrencesRange toDescriptorInvocationKind(ProtoBuf.Effect.InvocationKind $this$toDescriptorInvocationKind) {
            EventOccurrencesRange eventOccurrencesRange;
            switch (WhenMappings.$EnumSwitchMapping$3[$this$toDescriptorInvocationKind.ordinal()]) {
                case 1: {
                    eventOccurrencesRange = EventOccurrencesRange.AT_MOST_ONCE;
                    break;
                }
                case 2: {
                    eventOccurrencesRange = EventOccurrencesRange.EXACTLY_ONCE;
                    break;
                }
                case 3: {
                    eventOccurrencesRange = EventOccurrencesRange.AT_LEAST_ONCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return eventOccurrencesRange;
        }

        private final KotlinType extractType(ProtoBuf.Expression proto) {
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.isInstanceType(proto, this.typeTable);
            if (type2 == null) {
                return null;
            }
            return this.typeDeserializer.type(type2);
        }

        private final ConstantReference deserializeConstant(ProtoBuf.Expression.ConstantValue value2) {
            ConstantReference constantReference;
            switch (WhenMappings.$EnumSwitchMapping$4[value2.ordinal()]) {
                case 1: {
                    constantReference = BooleanConstantReference.Companion.getTRUE();
                    break;
                }
                case 2: {
                    constantReference = BooleanConstantReference.Companion.getFALSE();
                    break;
                }
                case 3: {
                    constantReference = ConstantReference.Companion.getNULL();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return constantReference;
        }

        private final ComplexExpressionType getComplexType(ProtoBuf.Expression proto) {
            boolean isOrSequence = proto.getOrArgumentCount() != 0;
            boolean isAndSequence = proto.getAndArgumentCount() != 0;
            return isOrSequence && isAndSequence ? null : (isOrSequence ? ComplexExpressionType.OR_SEQUENCE : (isAndSequence ? ComplexExpressionType.AND_SEQUENCE : null));
        }

        private final PrimitiveExpressionType getPrimitiveType(ProtoBuf.Expression proto) {
            List expressionTypes = new ArrayList();
            if (proto.hasValueParameterReference() && this.hasType(proto)) {
                expressionTypes.add(PrimitiveExpressionType.INSTANCE_CHECK);
            } else if (proto.hasValueParameterReference() && Flags.IS_NULL_CHECK_PREDICATE.get(proto.getFlags()).booleanValue()) {
                expressionTypes.add(PrimitiveExpressionType.NULLABILITY_CHECK);
            }
            if (!((Collection)expressionTypes).isEmpty()) {
                return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull(expressionTypes));
            }
            if (proto.hasValueParameterReference() && proto.getValueParameterReference() > 0) {
                expressionTypes.add(PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE);
            } else if (proto.hasValueParameterReference() && proto.getValueParameterReference() == 0) {
                expressionTypes.add(PrimitiveExpressionType.RECEIVER_REFERENCE);
            } else if (proto.hasConstantValue()) {
                expressionTypes.add(PrimitiveExpressionType.CONSTANT);
            }
            return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull(expressionTypes));
        }

        private final boolean hasType(ProtoBuf.Expression $this$hasType) {
            return $this$hasType.hasIsInstanceType() || $this$hasType.hasIsInstanceTypeId();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$ComplexExpressionType;", "", "<init>", "(Ljava/lang/String;I)V", "AND_SEQUENCE", "OR_SEQUENCE", "frontend"})
        private static final class ComplexExpressionType
        extends Enum<ComplexExpressionType> {
            public static final /* enum */ ComplexExpressionType AND_SEQUENCE = new ComplexExpressionType();
            public static final /* enum */ ComplexExpressionType OR_SEQUENCE = new ComplexExpressionType();
            private static final /* synthetic */ ComplexExpressionType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ComplexExpressionType[] values() {
                return (ComplexExpressionType[])$VALUES.clone();
            }

            public static ComplexExpressionType valueOf(String value2) {
                return Enum.valueOf(ComplexExpressionType.class, value2);
            }

            @NotNull
            public static EnumEntries<ComplexExpressionType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = complexExpressionTypeArray = new ComplexExpressionType[]{ComplexExpressionType.AND_SEQUENCE, ComplexExpressionType.OR_SEQUENCE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$PrimitiveExpressionType;", "", "<init>", "(Ljava/lang/String;I)V", "VALUE_PARAMETER_REFERENCE", "RECEIVER_REFERENCE", "CONSTANT", "INSTANCE_CHECK", "NULLABILITY_CHECK", "frontend"})
        private static final class PrimitiveExpressionType
        extends Enum<PrimitiveExpressionType> {
            public static final /* enum */ PrimitiveExpressionType VALUE_PARAMETER_REFERENCE = new PrimitiveExpressionType();
            public static final /* enum */ PrimitiveExpressionType RECEIVER_REFERENCE = new PrimitiveExpressionType();
            public static final /* enum */ PrimitiveExpressionType CONSTANT = new PrimitiveExpressionType();
            public static final /* enum */ PrimitiveExpressionType INSTANCE_CHECK = new PrimitiveExpressionType();
            public static final /* enum */ PrimitiveExpressionType NULLABILITY_CHECK = new PrimitiveExpressionType();
            private static final /* synthetic */ PrimitiveExpressionType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static PrimitiveExpressionType[] values() {
                return (PrimitiveExpressionType[])$VALUES.clone();
            }

            public static PrimitiveExpressionType valueOf(String value2) {
                return Enum.valueOf(PrimitiveExpressionType.class, value2);
            }

            @NotNull
            public static EnumEntries<PrimitiveExpressionType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = primitiveExpressionTypeArray = new PrimitiveExpressionType[]{PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE, PrimitiveExpressionType.RECEIVER_REFERENCE, PrimitiveExpressionType.CONSTANT, PrimitiveExpressionType.INSTANCE_CHECK, PrimitiveExpressionType.NULLABILITY_CHECK};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;
            public static final /* synthetic */ int[] $EnumSwitchMapping$4;

            static {
                int[] nArray = new int[ProtoBuf.Effect.EffectType.values().length];
                try {
                    nArray[ProtoBuf.Effect.EffectType.RETURNS_CONSTANT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.Effect.EffectType.CALLS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ComplexExpressionType.values().length];
                try {
                    nArray[ComplexExpressionType.AND_SEQUENCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ComplexExpressionType.OR_SEQUENCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[PrimitiveExpressionType.values().length];
                try {
                    nArray[PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveExpressionType.RECEIVER_REFERENCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveExpressionType.CONSTANT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveExpressionType.INSTANCE_CHECK.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PrimitiveExpressionType.NULLABILITY_CHECK.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[ProtoBuf.Effect.InvocationKind.values().length];
                try {
                    nArray[ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$3 = nArray;
                nArray = new int[ProtoBuf.Expression.ConstantValue.values().length];
                try {
                    nArray[ProtoBuf.Expression.ConstantValue.TRUE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.Expression.ConstantValue.FALSE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.Expression.ConstantValue.NULL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$4 = nArray;
            }
        }
    }
}

