/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;

class SshAgentPrivateKeyOp
extends SubsystemMessage {
    public static final int SSH_AGENT_PRIVATE_KEY_OP = 205;
    SshPublicKey pubkey;
    String operation;
    byte[] data;

    public SshAgentPrivateKeyOp() {
        super(205);
    }

    public SshAgentPrivateKeyOp(SshPublicKey pubkey, String operation, byte[] data) {
        super(205);
        this.pubkey = pubkey;
        this.operation = operation;
        this.data = data;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getOperation() {
        return this.operation;
    }

    public byte[] getOperationData() {
        return this.data;
    }

    public String getMessageName() {
        return "SSH_AGENT_PRIVATE_KEY_OP";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeString(this.operation);
            baw.writeBinaryString(this.pubkey.getEncoded());
            baw.write(this.data);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.operation = bar.readString();
            this.pubkey = SshKeyPairFactory.decodePublicKey(bar.readBinaryString());
            this.data = new byte[bar.available()];
            bar.read(this.data);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }
}

