/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssKeyPair;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaKeyPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyPairFactory {
    private static Map pks;
    private static String defaultAlgorithm;
    private static Log log;

    static {
        log = LogFactory.getLog(SshKeyPairFactory.class);
        pks = new HashMap();
        log.info("Loading public key algorithms");
        pks.put("ssh-dss", SshDssKeyPair.class);
        pks.put("ssh-rsa", SshRsaKeyPair.class);
        try {
            SshAPIConfiguration config;
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class) && (config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class)) != null) {
                List list = config.getPublicKeyExtensions();
                if (list != null) {
                    for (ExtensionAlgorithm algorithm : list) {
                        String name = algorithm.getAlgorithmName();
                        if (pks.containsKey(name)) {
                            log.debug("Standard public key " + name + " is being overidden by " + algorithm.getImplementationClass());
                        } else {
                            log.debug(String.valueOf(algorithm.getAlgorithmName()) + " public key is implemented by " + algorithm.getImplementationClass());
                        }
                        try {
                            pks.put(algorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(algorithm.getImplementationClass()));
                        }
                        catch (ClassNotFoundException cnfe) {
                            log.error("Could not locate " + algorithm.getImplementationClass());
                        }
                    }
                }
                defaultAlgorithm = config.getDefaultPublicKey();
            }
        }
        catch (ConfigurationException config) {
            // empty catch block
        }
        if (defaultAlgorithm == null || !pks.containsKey(defaultAlgorithm)) {
            log.debug("The default public key is not set! using first in list");
            Iterator it = pks.keySet().iterator();
            defaultAlgorithm = (String)it.next();
        }
    }

    protected SshKeyPairFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultPublicKey() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeys() {
        return new ArrayList(pks.keySet());
    }

    public static SshKeyPair newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyPair)((Class)pks.get(methodName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(String.valueOf(methodName) + " is not supported!");
        }
    }

    public static boolean supportsKey(String algorithm) {
        return pks.containsKey(algorithm);
    }

    public static SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader bar = new ByteArrayReader(encoded);
            String algorithm = bar.readString();
            if (SshKeyPairFactory.supportsKey(algorithm)) {
                SshKeyPair pair = SshKeyPairFactory.newInstance(algorithm);
                return pair.decodePrivateKey(encoded);
            }
            throw new AlgorithmNotSupportedException(String.valueOf(algorithm) + " is not supported");
        }
        catch (IOException ioe) {
            throw new InvalidSshKeyException(ioe.getMessage());
        }
    }

    public static SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException, AlgorithmNotSupportedException {
        try {
            ByteArrayReader bar = new ByteArrayReader(encoded);
            String algorithm = bar.readString();
            if (SshKeyPairFactory.supportsKey(algorithm)) {
                SshKeyPair pair = SshKeyPairFactory.newInstance(algorithm);
                return pair.decodePublicKey(encoded);
            }
            throw new AlgorithmNotSupportedException(String.valueOf(algorithm) + " is not supported");
        }
        catch (IOException ioe) {
            throw new InvalidSshKeyException(ioe.getMessage());
        }
    }
}

