/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.baseForm;

import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import edu.harvard.mgh.purcell.gPLINK2.forms.GenFileSet;
import edu.harvard.mgh.purcell.gPLINK2.forms.Merge;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class ThresholdDialog
extends JDialog {
    private static Logger logger = Logger.getLogger(ThresholdDialog.class);
    private static Double MAF_DEFAULT;
    private static Double MAXMAF_DEFAULT;
    private static Double GENO_DEFAULT;
    private static Double MIND_DEFAULT;
    private Form parent;
    private JTextField maf;
    private JTextField maxMaf;
    private JTextField geno;
    private JTextField mind;
    private JTextField hwe;
    private JTextField mendell;
    private JTextField mendell2;
    private JCheckBox mafButton;
    private JCheckBox maxMafButton;
    private JCheckBox genoButton;
    private JCheckBox hweButton;
    private JCheckBox mendellButton;
    private JCheckBox mindButton;
    private JButton okButton;
    private JButton resetButton;
    private JButton cancelButton;
    private WindowListener properClosing = new WindowListener(){

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
            ThresholdDialog.this.parent.openButtons();
        }

        public void windowClosing(WindowEvent e) {
            ThresholdDialog.this.parent.openButtons();
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }
    };
    ActionListener process = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (ThresholdDialog.this.mafButton.isSelected()) {
                ThresholdDialog.this.parent.addThreshold(" --maf " + ThresholdDialog.this.maf.getText());
            }
            if (ThresholdDialog.this.maxMafButton.isSelected()) {
                ThresholdDialog.this.parent.addThreshold(" --max-maf " + ThresholdDialog.this.maxMaf.getText());
            }
            if (ThresholdDialog.this.genoButton.isSelected()) {
                ThresholdDialog.this.parent.addThreshold(" --geno " + ThresholdDialog.this.geno.getText());
            }
            if (ThresholdDialog.this.mindButton.isSelected()) {
                ThresholdDialog.this.parent.addThreshold(" --mind " + ThresholdDialog.this.mind.getText());
            }
            if (ThresholdDialog.this.hweButton.isSelected()) {
                ThresholdDialog.this.parent.addThreshold(" --hwe " + ThresholdDialog.this.hwe.getText());
            }
            if (ThresholdDialog.this.mendellButton.isSelected()) {
                ThresholdDialog.this.parent.addThreshold(" --me " + ThresholdDialog.this.mendell.getText() + " " + ThresholdDialog.this.mendell2.getText());
            }
            ThresholdDialog.this.dispose();
        }
    };
    ItemListener validateOK = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            logger.info("[validateOK]");
            ThresholdDialog.this.validateButtons();
        }
    };
    DocumentListener validateDL = new DocumentListener(){

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            ThresholdDialog.this.validateButtons();
        }

        public void removeUpdate(DocumentEvent e) {
            ThresholdDialog.this.validateButtons();
        }
    };
    ActionListener reset = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ThresholdDialog.this.maf.setText(MAF_DEFAULT.toString());
            ThresholdDialog.this.maxMaf.setText(MAXMAF_DEFAULT.toString());
            ThresholdDialog.this.geno.setText(GENO_DEFAULT.toString());
            ThresholdDialog.this.mind.setText(MIND_DEFAULT.toString());
            ThresholdDialog.this.hwe.setText("");
            ThresholdDialog.this.mendell.setText("");
            ThresholdDialog.this.mendell2.setText("");
        }
    };
    ActionListener cancel = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ThresholdDialog.this.dispose();
        }
    };

    private void validateButtons() {
        if (this.mafButton.isSelected() && !this.maf.getText().matches("[0\\s].\\d*") && !this.maf.getText().matches("[10]") && !this.maf.getText().matches("1\\.0*")) {
            this.okButton.setEnabled(false);
            return;
        }
        if (this.maxMafButton.isSelected() && !this.maxMaf.getText().matches("[0\\s].\\d*") && !this.maxMaf.getText().matches("[10]") && !this.maxMaf.getText().matches("1\\.0*")) {
            this.okButton.setEnabled(false);
            return;
        }
        if (this.genoButton.isSelected() && !this.geno.getText().matches("[0\\s].\\d*") && !this.geno.getText().matches("[10]") && !this.geno.getText().matches("1\\.0*")) {
            this.okButton.setEnabled(false);
            return;
        }
        if (this.mindButton.isSelected() && !this.mind.getText().matches("[0\\s].\\d*") && !this.mind.getText().matches("[10]") && !this.mind.getText().matches("1\\.0*")) {
            this.okButton.setEnabled(false);
            return;
        }
        if (this.hweButton.isSelected() && !this.hwe.getText().matches("[0\\s].\\d*") && !this.hwe.getText().matches("[10]") && !this.hwe.getText().matches("1\\.0*")) {
            this.okButton.setEnabled(false);
            return;
        }
        if (!(!this.mendellButton.isSelected() || (this.mendell.getText().matches("[0\\s].\\d*") || this.mendell.getText().matches("[10]") || this.mendell.getText().matches("1\\.0*")) && (this.mendell2.getText().matches("[0\\s].\\d*") || this.mendell2.getText().matches("[10]") || this.mendell2.getText().matches("1\\.0*")))) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(true);
    }

    private void initalize() {
        if (this.parent.getClass().equals(GenFileSet.class) || this.parent.getClass().equals(Merge.class)) {
            MAF_DEFAULT = 0.0;
            GENO_DEFAULT = 1.0;
            MIND_DEFAULT = 1.0;
        } else {
            MAF_DEFAULT = 0.01;
            GENO_DEFAULT = 0.1;
            MIND_DEFAULT = 0.1;
        }
        MAXMAF_DEFAULT = 1.0;
        this.maf = new JTextField(MAF_DEFAULT.toString(), 10);
        this.maf.getDocument().addDocumentListener(this.validateDL);
        this.maxMaf = new JTextField(MAXMAF_DEFAULT.toString(), 10);
        this.maxMaf.getDocument().addDocumentListener(this.validateDL);
        this.geno = new JTextField(GENO_DEFAULT.toString(), 10);
        this.geno.getDocument().addDocumentListener(this.validateDL);
        this.hwe = new JTextField(10);
        this.hwe.getDocument().addDocumentListener(this.validateDL);
        this.mind = new JTextField(MIND_DEFAULT.toString(), 10);
        this.mind.getDocument().addDocumentListener(this.validateDL);
        this.mendell = new JTextField(10);
        this.mendell.getDocument().addDocumentListener(this.validateDL);
        this.mendell2 = new JTextField(10);
        this.mendell2.getDocument().addDocumentListener(this.validateDL);
        this.mafButton = new JCheckBox("Minor allele frequency (--maf)");
        this.mafButton.addItemListener(this.validateOK);
        Form.bundel((JToggleButton)this.mafButton, this.maf);
        this.maxMafButton = new JCheckBox("Maximum minor allele frequency (--max-maf)");
        this.maxMafButton.addItemListener(this.validateOK);
        Form.bundel((JToggleButton)this.maxMafButton, this.maxMaf);
        this.genoButton = new JCheckBox("Maximum SNP missingness rate (--geno)");
        this.genoButton.addItemListener(this.validateOK);
        Form.bundel((JToggleButton)this.genoButton, this.geno);
        this.hweButton = new JCheckBox("Hardy Weinberg equilibrium (--hwe)");
        this.hweButton.addItemListener(this.validateOK);
        Form.bundel((JToggleButton)this.hweButton, this.hwe);
        JTextField[] temp = new JTextField[]{this.mendell, this.mendell2};
        this.mendellButton = new JCheckBox("Mendel errors (--me)");
        this.mendellButton.addItemListener(this.validateOK);
        Form.bundel((JToggleButton)this.mendellButton, temp);
        this.mindButton = new JCheckBox("Maximum individual missingness rate (--mind)");
        this.mindButton.addItemListener(this.validateOK);
        Form.bundel((JToggleButton)this.mindButton, this.mind);
    }

    public ThresholdDialog(Form givenParent) {
        super((Dialog)givenParent, "Threshold");
        this.parent = givenParent;
        this.parent.closeButtons();
        this.parent.resetThreshold();
        this.initalize();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel mafPanel = new JPanel();
        mafPanel.setLayout(new FlowLayout(3));
        mafPanel.add(this.mafButton);
        mafPanel.add(this.maf);
        JPanel maxPanel = new JPanel();
        maxPanel.setLayout(new FlowLayout(3));
        maxPanel.add(this.maxMafButton);
        maxPanel.add(this.maxMaf);
        JPanel genoPanel = new JPanel();
        genoPanel.setLayout(new FlowLayout(3));
        genoPanel.add(this.genoButton);
        genoPanel.add(this.geno);
        JPanel mindPanel = new JPanel();
        mindPanel.setLayout(new FlowLayout(3));
        mindPanel.add(this.mindButton);
        mindPanel.add(this.mind);
        JPanel hwePanel = new JPanel();
        hwePanel.setLayout(new FlowLayout(3));
        hwePanel.add(this.hweButton);
        hwePanel.add(this.hwe);
        JPanel mendPanel = new JPanel();
        mendPanel.setLayout(new FlowLayout(3));
        mendPanel.add(this.mendellButton);
        mendPanel.add(new JLabel("(family)"));
        mendPanel.add(this.mendell);
        mendPanel.add(new JLabel("(snp)"));
        mendPanel.add(this.mendell2);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this.process);
        buttonPanel.add(this.okButton);
        this.resetButton = new JButton("Restore Default");
        this.resetButton.addActionListener(this.reset);
        buttonPanel.add(this.resetButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this.cancel);
        buttonPanel.add(this.cancelButton);
        this.getContentPane().add(mafPanel);
        this.getContentPane().add(maxPanel);
        this.getContentPane().add(genoPanel);
        this.getContentPane().add(mindPanel);
        this.getContentPane().add(hwePanel);
        this.getContentPane().add(mendPanel);
        this.getContentPane().add(buttonPanel);
        this.addWindowListener(this.properClosing);
        this.pack();
        this.setVisible(true);
    }
}

