/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;

public class CCAssoc
extends Form {
    public static String name = "Genotypic C/C association tests";
    JCheckBox ciButton;
    JCheckBox adjustButton;
    JCheckBox cellButton;
    JRadioButton mperm2Button;
    JRadioButton perm2Button;
    JRadioButton mGenButton;
    JRadioButton mTrendButton;
    JRadioButton mDomButton;
    JRadioButton mRecButton;
    JRadioButton mBestButton;
    JTextField ciText;
    JTextField cText;
    JTextField mperm2Text;
    private static Double CI_DEFAULT = new Double(0.95);
    private static Integer MPERM_DEFAULT = new Integer(1000);
    private static Integer CELL_DEFAULT = new Integer(5);

    public CCAssoc(GPLINK mf) {
        super(mf, name);
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        JPanel body = new JPanel();
        body.setLayout(new BoxLayout(body, 3));
        this.ciText = new JTextField(CI_DEFAULT.toString(), 4);
        this.ciText.getDocument().addDocumentListener(this.validateBodyDL);
        this.cText = new JTextField(CELL_DEFAULT.toString(), 4);
        this.cText.getDocument().addDocumentListener(this.validateBodyDL);
        this.mperm2Text = new JTextField(MPERM_DEFAULT.toString(), 4);
        this.mperm2Text.getDocument().addDocumentListener(this.validateBodyDL);
        this.cellButton = new JCheckBox("Minimum required observation per cell (--cell)");
        this.cellButton.addActionListener(this.validateBodyAL);
        CCAssoc.bundel((JToggleButton)this.cellButton, this.cText);
        this.ciButton = new JCheckBox("Confidence intervals (--ci)");
        this.ciButton.addActionListener(this.validateBodyAL);
        CCAssoc.bundel((JToggleButton)this.ciButton, this.ciText);
        this.adjustButton = new JCheckBox("Adjusted p-values (--adjust)");
        this.adjustButton.addActionListener(this.validateBodyAL);
        this.mperm2Button = new JRadioButton("max(T) permutation mode (--mperm)");
        this.mperm2Button.addActionListener(this.validateBodyAL);
        CCAssoc.bundel((JToggleButton)this.mperm2Button, this.mperm2Text);
        this.perm2Button = new JRadioButton("Adaptive permutation mode (--perm)");
        this.perm2Button.addActionListener(this.validateBodyAL);
        this.mBestButton = new JRadioButton("Permute best test (default)");
        this.mBestButton.addActionListener(this.validateBodyAL);
        this.mGenButton = new JRadioButton("Permute genotypic test (--model-gen)");
        this.mGenButton.addActionListener(this.validateBodyAL);
        this.mTrendButton = new JRadioButton("Permute trend test (--model-trend)");
        this.mTrendButton.addActionListener(this.validateBodyAL);
        this.mDomButton = new JRadioButton("Permute dominant test (--model-dom)");
        this.mDomButton.addActionListener(this.validateBodyAL);
        this.mRecButton = new JRadioButton("Permute recessive test (--model-rec)");
        this.mRecButton.addActionListener(this.validateBodyAL);
        ButtonGroup g1 = new ButtonGroup();
        g1.add(this.mBestButton);
        g1.add(this.mGenButton);
        g1.add(this.mDomButton);
        g1.add(this.mRecButton);
        g1.add(this.mTrendButton);
        ActionListener changePerm = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CCAssoc.this.mperm2Button.isSelected()) {
                    CCAssoc.this.perm2Button.setSelected(false);
                }
            }
        };
        ActionListener changeMperm = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CCAssoc.this.perm2Button.isSelected()) {
                    CCAssoc.this.mperm2Button.setSelected(false);
                }
            }
        };
        this.perm2Button.addActionListener(changeMperm);
        this.mperm2Button.addActionListener(changePerm);
        body.setLayout(new BoxLayout(body, 3));
        body.add(Box.createRigidArea(new Dimension(0, 10)));
        body.add(new JLabel("Genotypic association tests (C/C) (--model)"));
        body.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel cellPanel = new JPanel();
        cellPanel.add(this.cellButton);
        cellPanel.add(this.cText);
        cellPanel.setLayout(new BoxLayout(cellPanel, 0));
        cellPanel.setAlignmentX(0.0f);
        body.add(cellPanel);
        JPanel ciPanel = new JPanel();
        ciPanel.add(this.ciButton);
        ciPanel.add(this.ciText);
        ciPanel.setLayout(new BoxLayout(ciPanel, 0));
        ciPanel.setAlignmentX(0.0f);
        body.add(ciPanel);
        this.adjustButton.setAlignmentX(0.0f);
        body.add(this.adjustButton);
        body.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel constraints = new JPanel();
        constraints.setBorder(new TitledBorder("Permutation options"));
        constraints.setLayout(new BoxLayout(constraints, 1));
        constraints.setAlignmentX(0.0f);
        JPanel mp2Panel = new JPanel();
        mp2Panel.add(this.mperm2Button);
        mp2Panel.add(this.mperm2Text);
        mp2Panel.setLayout(new BoxLayout(mp2Panel, 0));
        mp2Panel.setAlignmentX(0.0f);
        constraints.add(mp2Panel);
        this.perm2Button.setAlignmentX(0.0f);
        constraints.add(this.perm2Button);
        constraints.add(Box.createRigidArea(new Dimension(0, 15)));
        this.mBestButton.setAlignmentX(0.0f);
        this.mBestButton.setSelected(true);
        constraints.add(this.mBestButton);
        this.mGenButton.setAlignmentX(0.0f);
        constraints.add(this.mGenButton);
        this.mTrendButton.setAlignmentX(0.0f);
        constraints.add(this.mTrendButton);
        this.mDomButton.setAlignmentX(0.0f);
        constraints.add(this.mDomButton);
        this.mRecButton.setAlignmentX(0.0f);
        constraints.add(this.mRecButton);
        body.add(constraints);
        return body;
    }

    protected void isBodyValid() {
        this.validBody = this.cellButton.isSelected() && !this.cText.getText().matches("\\d*\\.?\\d+") ? false : (this.ciButton.isSelected() && !this.ciText.getText().matches("\\d*\\.?\\d+") ? false : !this.mperm2Button.isSelected() || this.mperm2Text.getText().matches("\\d*\\.?\\d+"));
        this.okForm();
    }

    protected String processBody() {
        String ans = "";
        ans = String.valueOf(ans) + "--model";
        if (this.ciButton.isSelected()) {
            ans = String.valueOf(ans) + " --ci " + this.ciText.getText();
        }
        if (this.mperm2Button.isSelected()) {
            ans = String.valueOf(ans) + " --mperm " + this.mperm2Text.getText();
        }
        if (this.perm2Button.isSelected()) {
            ans = String.valueOf(ans) + " --perm";
        }
        if (this.adjustButton.isSelected()) {
            ans = String.valueOf(ans) + " --adjust";
        }
        if (this.cellButton.isSelected()) {
            ans = String.valueOf(ans) + " --cell " + this.cText.getText();
        }
        if (this.mGenButton.isSelected()) {
            ans = String.valueOf(ans) + " --model-gen";
        }
        if (this.mTrendButton.isSelected()) {
            ans = String.valueOf(ans) + " --model-trend";
        }
        if (this.mDomButton.isSelected()) {
            ans = String.valueOf(ans) + " --model-dom";
        }
        if (this.mRecButton.isSelected()) {
            ans = String.valueOf(ans) + " --model-rec";
        }
        return ans;
    }
}

