/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.ContextSupport;
import nu.xom.jaxen.JaxenException;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.UnresolvableException;
import nu.xom.jaxen.expr.DefaultStep;
import nu.xom.jaxen.expr.IdentitySet;
import nu.xom.jaxen.expr.NameStep;
import nu.xom.jaxen.expr.PredicateSet;
import nu.xom.jaxen.expr.iter.IterableAxis;

public class DefaultNameStep
extends DefaultStep
implements NameStep {
    private static final long serialVersionUID = 428414912247718390L;
    private String prefix;
    private String localName;
    private boolean matchesAnyName;
    private boolean hasPrefix;

    public DefaultNameStep(IterableAxis iterableAxis, String string, String string2, PredicateSet predicateSet) {
        super(iterableAxis, predicateSet);
        this.prefix = string;
        this.localName = string2;
        this.matchesAnyName = "*".equals(string2);
        this.hasPrefix = this.prefix != null && this.prefix.length() > 0;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public boolean isMatchesAnyName() {
        return this.matchesAnyName;
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getAxisName()).append("::");
        if (this.getPrefix() != null && this.getPrefix().length() > 0) {
            stringBuffer.append(this.getPrefix()).append(':');
        }
        return stringBuffer.append(this.getLocalName()).append(super.getText()).toString();
    }

    @Override
    public List evaluate(Context context) throws JaxenException {
        boolean bl;
        List list = context.getNodeSet();
        int n = list.size();
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ContextSupport contextSupport = context.getContextSupport();
        IterableAxis iterableAxis = this.getIterableAxis();
        boolean bl2 = bl = !this.matchesAnyName && iterableAxis.supportsNamedAccess(contextSupport);
        if (n == 1) {
            Object e = list.get(0);
            if (bl) {
                String string = null;
                if (this.hasPrefix && (string = contextSupport.translateNamespacePrefixToUri(this.prefix)) == null) {
                    throw new UnresolvableException("XPath expression uses unbound namespace prefix " + this.prefix);
                }
                Iterator iterator = iterableAxis.namedAccessIterator(e, contextSupport, this.localName, this.prefix, string);
                if (iterator == null || !iterator.hasNext()) {
                    return Collections.EMPTY_LIST;
                }
                ArrayList arrayList = new ArrayList();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
            }
            Iterator iterator = iterableAxis.iterator(e, contextSupport);
            if (iterator == null || !iterator.hasNext()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList arrayList = new ArrayList(n);
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!this.matches(e2, contextSupport)) continue;
                arrayList.add(e2);
            }
            return this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
        }
        IdentitySet identitySet = new IdentitySet();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        ArrayList arrayList2 = new ArrayList(n);
        if (bl) {
            String string = null;
            if (this.hasPrefix && (string = contextSupport.translateNamespacePrefixToUri(this.prefix)) == null) {
                throw new UnresolvableException("XPath expression uses unbound namespace prefix " + this.prefix);
            }
            for (int i = 0; i < n; ++i) {
                Object object;
                Object e = list.get(i);
                Iterator iterator = iterableAxis.namedAccessIterator(e, contextSupport, this.localName, this.prefix, string);
                if (iterator == null || !iterator.hasNext()) continue;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    arrayList.add(object);
                }
                object = this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Object e3 = iterator2.next();
                    if (identitySet.contains(e3)) continue;
                    identitySet.add(e3);
                    arrayList2.add(e3);
                }
                arrayList.clear();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Object object;
                Object e = list.get(i);
                Iterator iterator = this.axisIterator(e, contextSupport);
                if (iterator == null || !iterator.hasNext()) continue;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!this.matches(object, contextSupport)) continue;
                    arrayList.add(object);
                }
                object = this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
                for (Object e4 : object) {
                    if (identitySet.contains(e4)) continue;
                    identitySet.add(e4);
                    arrayList2.add(e4);
                }
                arrayList.clear();
            }
        }
        return arrayList2;
    }

    @Override
    public boolean matches(Object object, ContextSupport contextSupport) throws JaxenException {
        Navigator navigator = contextSupport.getNavigator();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (navigator.isElement(object)) {
            string2 = navigator.getElementName(object);
            string3 = navigator.getElementNamespaceUri(object);
        } else {
            if (navigator.isText(object)) {
                return false;
            }
            if (navigator.isAttribute(object)) {
                if (this.getAxis() != 9) {
                    return false;
                }
                string2 = navigator.getAttributeName(object);
                string3 = navigator.getAttributeNamespaceUri(object);
            } else {
                if (navigator.isDocument(object)) {
                    return false;
                }
                if (navigator.isNamespace(object)) {
                    if (this.getAxis() != 10) {
                        return false;
                    }
                    string2 = navigator.getNamespacePrefix(object);
                } else {
                    return false;
                }
            }
        }
        if (this.hasPrefix) {
            string = contextSupport.translateNamespacePrefixToUri(this.prefix);
            if (string == null) {
                throw new UnresolvableException("Cannot resolve namespace prefix '" + this.prefix + "'");
            }
        } else if (this.matchesAnyName) {
            return true;
        }
        if (this.hasNamespace(string) != this.hasNamespace(string3)) {
            return false;
        }
        if (this.matchesAnyName || string2.equals(this.getLocalName())) {
            return this.matchesNamespaceURIs(string, string3);
        }
        return false;
    }

    private boolean hasNamespace(String string) {
        return string != null && string.length() > 0;
    }

    protected boolean matchesNamespaceURIs(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null) {
            return string2.length() == 0;
        }
        if (string2 == null) {
            return string.length() == 0;
        }
        return string.equals(string2);
    }

    @Override
    public String toString() {
        String string = this.getPrefix();
        String string2 = "".equals(string) ? this.getLocalName() : this.getPrefix() + ":" + this.getLocalName();
        return "[(DefaultNameStep): " + string2 + "]";
    }
}

