#ifndef ReiserFileSystem_H
#define ReiserFileSystem_H

#include "IFileSystem.h"
#include "ReiserDiskAccess.h"

class ReiserFsPartition;

class ReiserFileSystem : public IFileSystem
{
public:
	ReiserFileSystem(const DWORD disk, const LONGLONG startingOffset, const LONGLONG length);
	virtual ~ReiserFileSystem();

    // IFileSystem implementation
	virtual HANDLE OpenFile(LPCTSTR szFilename) const;
	virtual void ReadFile(HANDLE hFile, LPVOID lpBuffer, DWORD NumberOfBytesToRead, DWORD& NumberOfBytesRead) const;
	virtual void CloseFile(HANDLE hFile) const;
	virtual HANDLE FindFirstFile(LPCTSTR szPath) const;
	virtual bool FindNextFile(HANDLE hFind, UNIX_FILEINFO& FileInfo) const;
	virtual void CloseFind(HANDLE hFind) const;

protected:
    void MakeSurePartitionIsOpen(); // CONST SUCKS! 

    ReiserDiskAccess m_Disk;
    ReiserFsPartition* m_Partition;
};

#endif // ReiserFileSystem_H
